<?php

    // Get Total UnRead
    $notificationsUnRead = DB::table('requests')->where('read', '0')->count('id');

    $messages = DB::table('mailbox')
        ->limit(5)
        ->orderByDesc('id')
        ->get(['id', 'name', 'subject', 'created_at', 'read'])
        ->toArray();

    // Get Total UnRead
    $messagesUnRead = DB::table('mailbox')->where('read', '0')->count('id');

?>

<nav id="navbar" class="navbar-fixed navbar-main-width">

    <section id="start-of-navbar" class=" d-inline-block">
        <div id="btn-aside-toggle"><i class="fas fa-bars"></i></div>
    </section><!-- start of navbar -->

    <section id="end-of-navbar" class="d-inline-block">

        <div id="notifications" class=" d-inline-block">

            <div class="dropdown-box dropdown open">

                <a href="<?php echo e(adminUrl('requests')); ?>" class="btn-toggle dropdown-toggle" type="button">
                    <span class="icon">
                        <i class="fa-regular fa-bell"></i>
                    </span>

                    <span
                        class="count <?php if($notificationsUnRead == 0): ?> <?php echo e('display-none'); ?> <?php endif; ?>"><?php echo e($notificationsUnRead); ?></span>
                </a><!-- Button -->



            </div>


        </div><!-- notifications -->


        <div id="messages" class=" d-inline-block">

            <div class="dropdown-box dropdown open">

                <button class="btn-toggle dropdown-toggle" type="button" id="triggerId" data-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <span class="icon">
                        <i class="fa-regular fa-envelope"></i>
                    </span>
                    <span
                        class="count <?php if($messagesUnRead == 0): ?> <?php echo e('display-none'); ?> <?php endif; ?>"><?php echo e($messagesUnRead); ?></span>
                </button><!-- Button -->

                <div class="data dropdown-menu scroll" aria-labelledby="triggerId">
                    <ul class="ul-items">

                        <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="li-item">
                                <a href="<?php echo e(adminUrl('mail/read/' . $msg->id)); ?>">
                                    <h6
                                        class="name <?php if($msg->read == '1'): ?> <?php echo e('text-main'); ?> <?php endif; ?> mb-0 font-weight-600">
                                        <?php echo e($msg->name); ?>


                                        <?php if($msg->read == '0'): ?>
                                            <span style="font-size: 8px"
                                                class="  text-white bg-primary px-2 py-1 radius float-left ">
                                                غير مقروء</span>
                                        <?php endif; ?>
                                    </h6>
                                    <span class="title"><?php echo e(Str::limit($msg->subject, 85)); ?></span>

                                </a>
                                <br>
                                <span class="time">
                                    <i class="fa-regular fa-clock"></i>
                                    <span class="mx-1"><?php echo e(parseTime($msg->created_at)); ?></span>
                                </span>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                    <a class="read-more text-center d-block" href="<?php echo e(adminUrl('mail')); ?>">عرض المزيد</a>

                </div><!-- data -->

            </div>


        </div><!-- notifications -->

    </section><!-- end of navbar -->

</nav><!-- NavBar -->
<?php /**PATH C:\xampp\htdocs\wjhatna\resources\views/dashboard/layouts/menus/navbar.blade.php ENDPATH**/ ?>