<!DOCTYPE html>
<html lang="ar">

<head>
    <title><?php echo $__env->yieldContent('title'); ?></title>

    <?php echo $__env->make('dashboard.layouts.meta.meta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <meta name="robots" content="noindex, nofollow">

    <!-- bootstrap -->
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/plugins/bootstrap/bootstrap.min.css')); ?>" />
    <!--  -->
    <link rel="stylesheet" href="<?php echo e(asset('dashboard/css/themes/light.css')); ?>" />
    <!-- navbar -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/layouts/navbar.css')); ?>" />
    <!--  -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/global/global.css')); ?>" />

    <?php echo $__env->yieldContent('css'); ?>
</head>

<body>


    <?php if(!isset($removeNavbar)): ?>
        <nav id="navbar" class="nav-main-theme navbar navbar-expand-xl ">
            <div class="container">

                <a class="navbar-brand ">
                    <img id="navbar-brand-logo" src="<?php echo e(website_logo()); ?>" alt="">
                </a>


                <button id="btn-navbar-toggler" class="navbar-toggler d-xl-none" type="button" data-toggle="collapse"
                    data-target="#collapsibleNavId" aria-controls="collapsibleNavId" aria-expanded="false"
                    aria-label="Toggle navigation">
                    <span class="icon-1"></span>
                    <span class="icon-2"></span>
                    <span class="icon-3"></span>
                </button>



                <div class="collapse navbar-collapse" id="collapsibleNavId">
                    <ul class="navbar-nav first-navbar-nav mr-auto mt-2 mt-xl-0">



                        <li class="nav-item">
                            <a class="nav-link" href="#gallery">الصور</a>
                        </li>


                        <li class="nav-item">
                            <a class="nav-link" href="#desc">الوصف</a>
                        </li>


                        <li class="nav-item">
                            <a class="nav-link" href="#details">التفاصيل</a>
                        </li>



                        <?php if($row->google_map_iframe): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="#location">الموقع</a>
                            </li>
                        <?php endif; ?>



                        <li class="nav-item">
                            <a class="nav-link" href="#features">المميزات</a>
                        </li>


                        <li class="nav-item">
                            <a class="nav-link" href="#amenities">وسائل الراحة</a>
                        </li>






                    </ul>
                </div>
            </div>
        </nav>
    <?php endif; ?>






    <!-- Start Contact Yield In Container -->
    <?php echo $__env->yieldContent('content'); ?>
    <!-- End Contact Yield In Container -->



    <!-- jquery -->
    <script src="<?php echo e(asset('dashboard/plugins/jquery/jquery-3.6.0.min.js')); ?>"></script>
    <!-- popper-->
    <script src="<?php echo e(asset('dashboard/plugins/popper/popper.min.js')); ?>"></script>
    <!-- bootstrap-->
    <script src="<?php echo e(asset('dashboard/plugins/bootstrap/bootstrap.min.js')); ?>"></script>
    <!-- lazy -->
    <script src="<?php echo e(asset('dashboard/plugins/lazy/lazy.js')); ?>"></script>
    <!-- Plugins Run And Custom -->
    <script type='text/javascript' src="<?php echo e(asset('assets/js/plugins.js')); ?>"></script>
    <!--  -->
    <script type='text/javascript' src="<?php echo e(asset('assets/js/layouts/navbar.js')); ?>"></script>
    <?php echo $__env->yieldContent('js'); ?>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\internal-real-estate\resources\views/main/layouts/master.blade.php ENDPATH**/ ?>