<?php
    $removeFooter = true;
    $removeNavbar = true;
    $removePhone = true;
?>

<?php $__env->startSection('title', $row->name); ?>
<?php $__env->startSection('description', Str::limit($row->desc, 150)); ?>
<?php $__env->startSection('type', 'product'); ?>
<?php $__env->startSection('image', largeAsset('products/' . $row->main_image)); ?>
<?php $__env->startSection('meta'); ?>
    <meta property="product:publisher" content="<?php echo e($row->name); ?>">
    <meta property="product:published_time" content="<?php echo e($row->created_at); ?>">
    <meta property="product:modified_time" content="<?php echo e($row->updated_at); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <style>
        :root {
            --main-color: <?php echo e($row->navbar_bg); ?>;
        }
    </style>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/pages/products/show.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.css"
        integrity="sha512-nNlU0WK2QfKsuEmdcTwkeh+lhGs6uyOxuUs+n+0oXSYDok5qy0EI0lt01ZynHq6+p/tbgpZ7P+yUb+r71wqdXg=="
        crossorigin="anonymous" referrerpolicy="no-referrer">

    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/ticker/theme.css')); ?>">

    <style>
        .animated-button {
            transform: scale(1) !important;
            background-image: linear-gradient(to right, <?php echo e($row->navbar_bg); ?>, #00cc66);
            background-size: 200% 100%;
            background-position: right;
            /* البداية من اليمين */
            transition: background-position 0.5s ease;
            animation: backgroundSlide 3s infinite alternate;
            t
        }

        /* أنيميشن تحريك الخلفية من اليمين لليسار */
        @keyframes backgroundSlide {
            0% {
                background-position: right;
                /* بداية من اليمين */
            }

            100% {
                background-position: left;
                /* نهاية عند اليسار */
            }
        }

        .animated-button:hover {
            background-position: left;
            /* عند التمرير بالماوس */
        }
    </style>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <?php
        if ($row->get_status->id == 1) {
            $badgeStatusColor = 'success';
        } elseif ($row->get_status->id == 2) {
            $badgeStatusColor = 'danger';
        } elseif ($row->get_status->id == 3) {
            $badgeStatusColor = 'blue';
        } else {
            $badgeStatusColor = 'dark';
        }
    ?>


    <?php if(count($row->get_news) != 0): ?>
        <div style="direction: ltr" class="TickerNews fixed-top" id="T1">
            <div class="ti_wrapper">
                <div class="ti_slide">
                    <div class="ti_content">
                        <?php $__currentLoopData = $row->get_news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div style="direction: rtl" class="ti_news">
                                <a>
                                    <?php echo e($news->desc); ?>

                                    <img width="28px" class="mx-3" src="<?php echo e(largeAsset('ads-products/' . $row->logo)); ?>"
                                        alt="">
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>





    <nav style="background-color: <?php echo e($row->navbar_bg); ?>;<?php if(count($row->get_news) != 0): ?> <?php echo e('margin-top:65px;'); ?> <?php endif; ?>"
        class="navbar navbar-expand-xl py-0">


        <div class="container">

            <a class="navbar-brand pr-0" href="<?php echo e(url()->current()); ?>">
                <img style="width: 75px !important;height:75px; object-fit:contain;" id="navbar-brand-logo" class=" ml-2"
                    src="<?php echo e(largeAsset('ads-products/' . $row->logo)); ?>" alt="">

            </a>

            <button id="btn-navbar-toggler" class="navbar-toggler d-xl-none" type="button" data-toggle="collapse"
                data-target="#collapsibleNavId" aria-controls="collapsibleNavId" aria-expanded="false"
                aria-label="Toggle navigation">
                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="<?php echo e($row->navbar_color); ?>"
                    viewBox="0 0 256 256">
                    <path
                        d="M224,128a8,8,0,0,1-8,8H40a8,8,0,0,1,0-16H216A8,8,0,0,1,224,128ZM40,72H216a8,8,0,0,0,0-16H40a8,8,0,0,0,0,16ZM216,184H40a8,8,0,0,0,0,16H216a8,8,0,0,0,0-16Z">
                    </path>
                </svg>
            </button>

            <div class="collapse navbar-collapse" id="collapsibleNavId">
                <ul class="navbar-nav first-navbar-nav mr-auto mt-2 mt-xl-0">

                    <?php $__currentLoopData = [
            [
                'name' => 'نظرة عامة',
                'link' => '#overview',
            ],
            [
                'name' => 'وصف المشروع',
                'link' => '#desc',
            ],
            [
                'name' => 'النماذج',
                'link' => '#models',
            ],
            [
                'name' => 'سمات الوحدة',
                'link' => '#attributes',
            ],
            [
                'name' => 'فيديو للمشروع',
                'link' => '#video',
            ],
        ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a style="color:<?php echo e($row->navbar_color); ?>" class="nav-link"
                                href="<?php echo e($link['link']); ?>"><?php echo e($link['name']); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                </ul>
            </div>
        </div>
    </nav>




    <header>
        <div class="container ">
            <div class="d-none d-md-block">
                <div class="row">
                    <div class="col-md-9">
                        <h1 class="product-name pt-4"><?php echo e($row->name); ?></h1>
                        <?php if($row->get_deal_type != null): ?>
                            <span class="badge-deal-type"><?php echo e($row->get_deal_type->type); ?></span>
                            <?php endif; ?> <?php if($row->get_status != null): ?>
                                <span class="badge-status <?php echo e($badgeStatusColor); ?>"><?php echo e($row->get_status->status); ?></span>
                            <?php endif; ?>
                            <div class="info mt-4">
                                <img style="width:9px" src="<?php echo e(asset('assets/images/products/city.svg')); ?>" alt="">
                                <?php if($row->get_city != null): ?>
                                    <span class="mr-1 ml-3"><?php echo e($row->get_city->name); ?></span>
                                <?php endif; ?> <img style="width:18px"
                                    src="<?php echo e(asset('assets/images/products/region.svg')); ?>" alt="">
                                <?php if($row->get_region != null): ?>
                                    <span class="mr-1"><?php echo e($row->get_region->name); ?></span>
                                <?php endif; ?>
                            </div>
                    </div>
                    <div class="col-md-3 price">
                        <div class="d-inline-block set-price"
                            data-price="<?php echo e(number_format($row->price, 0, '.', ',')); ?> ريال سعودي"></div>
                    </div>
                </div>
            </div>
            <div class="gallery mt-4"><img class="w-100" src="<?php echo e(largeAsset('ads-products/' . $row->main_image)); ?>"
                    alt="">
                <div dir="ltr" class="owl-carousel owl-theme mt-4">
                    <?php $__currentLoopData = $gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gall): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="item"><a href="<?php echo e(largeAsset('ads-products/gallery/' . $gall)); ?>"
                                data-fancybox="gallery" data-caption=""><img
                                    src="<?php echo e(smallAsset('ads-products/gallery/' . $gall)); ?>" alt=""></a></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="d-block d-md-none mt-3">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="">
                                <?php if($row->get_deal_type != null): ?>
                                    <span class="badge-deal-type"><?php echo e($row->get_deal_type->type); ?></span>
                                    <?php endif; ?> <?php if($row->get_status != null): ?>
                                        <span
                                            class="badge-status <?php echo e($badgeStatusColor); ?>"><?php echo e($row->get_status->status); ?></span>
                                    <?php endif; ?>
                            </div>
                            <div class="clearfix"></div>
                            <h2 class="product-name mb-3 mt-4"><?php echo e($row->name); ?></h2>
                            <div class="info"><img style="width:9px" src="<?php echo e(asset('assets/images/products/city.svg')); ?>"
                                    alt="">
                                <?php if($row->get_city != null): ?>
                                    <span class="mr-1 ml-3"><?php echo e($row->get_city->name); ?></span>
                                <?php endif; ?> <img style="width:18px"
                                    src="<?php echo e(asset('assets/images/products/region.svg')); ?>" alt="">
                                <?php if($row->get_region != null): ?>
                                    <span class="mr-1"><?php echo e($row->get_region->name); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-3 price mt-3 text-right">
                            <div class="d-inline-block set-price"
                                data-price="<?php echo e(number_format($row->price, 0, '.', ',')); ?> ريال سعودي"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>






    <main class="mt-3">

        <div id="overview">
            <div class="container">
                <div class="row">
                    <div class="col-md-9">
                        <div class="box px-0 mb-4 p-4">
                            <h5 class="box-title mb-0 float-right pr-0">نظرة عامة</h5>
                            <h6 class="float-left mb-0 d-none d-md-inline-block">رقم ترخيص : <?php echo e($row->license_number); ?>

                            </h6>
                            <div class="clearfix"></div>
                            <hr>
                            <div class="box-body p-0">
                                <div class="row">
                                    <div class="col-md-9">
                                        <div class="row">
                                            <div class="col-md-4 col-6 item-box">
                                                <div class="key">نوع العقار</div>
                                                <div class="val mt-1"><small><?php echo e($row->get_build_type->type); ?></small>
                                                </div>
                                            </div>
                                            <div class="col-md-4 col-6 item-box">
                                                <div class="key"><span
                                                        class="count"><?php echo e($row->room_numbers); ?></span><img
                                                        style="width:26px"
                                                        src="<?php echo e(asset('assets/images/products/room.svg')); ?>"
                                                        alt=""></div>
                                                <div class="val">غرفة نوم</div>
                                            </div>
                                            <div class="col-md-4 col-6 item-box">
                                                <div class="key"><span
                                                        class="count"><?php echo e($row->bathrooms_numbers); ?></span><img
                                                        style="width:26px"
                                                        src="<?php echo e(asset('assets/images/products/bathroom.svg')); ?>"
                                                        alt=""></div>
                                                <div class="val">حمام</div>
                                            </div>
                                            <div class="col-md-4 col-6 item-box">
                                                <div class="key">حالة العقار</div>
                                                <div class="val mt-1"><small><?php echo e($row->get_status->status); ?></small></div>
                                            </div>
                                            <?php if($row->parking_numbers != null): ?>
                                                <div class="col-md-4 col-6 item-box">
                                                    <div class="key"><span
                                                            class="count"><?php echo e($row->parking_numbers); ?></span><img
                                                            style="width:26px"
                                                            src="<?php echo e(asset('assets/images/products/car.svg')); ?>"
                                                            alt=""></div>
                                                    <div class="val">موقف سيارات</div>
                                                </div>
                                            <?php endif; ?>
                                            <div class="col-md-4 col-6 item-box">
                                                <div class="key"><span
                                                        class="count"><?php echo e($row->area_in_metres); ?></span><img
                                                        style="width:26px"
                                                        src="<?php echo e(asset('assets/images/products/mtr.svg')); ?>"
                                                        alt=""></div>
                                                <div class="val">المساحة</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="share-box"><button class="share"><svg
                                                    xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                                    fill="#000000" viewBox="0 0 256 256">
                                                    <path
                                                        d="M176,160a39.89,39.89,0,0,0-28.62,12.09l-46.1-29.63a39.8,39.8,0,0,0,0-28.92l46.1-29.63a40,40,0,1,0-8.66-13.45l-46.1,29.63a40,40,0,1,0,0,55.82l46.1,29.63A40,40,0,1,0,176,160Zm0-128a24,24,0,1,1-24,24A24,24,0,0,1,176,32ZM64,152a24,24,0,1,1,24-24A24,24,0,0,1,64,152Zm112,72a24,24,0,1,1,24-24A24,24,0,0,1,176,224Z">
                                                    </path>
                                                </svg>مشاركة</button>
                                            <div class="parnet-links">
                                                <div class="share-links"><a class="link"
                                                        href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(url()->current()); ?>"><svg
                                                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512">
                                                            <path
                                                                d="M80 299.3V512H196V299.3h86.5l18-97.8H196V166.9c0-51.7 20.3-71.5 72.7-71.5c16.3 0 29.4 .4 37 1.2V7.9C291.4 4 256.4 0 236.2 0C129.3 0 80 50.5 80 159.4v42.1H14v97.8H80z" />
                                                        </svg></a><a class="link"
                                                        href="whatsapp://send?text=<?php echo e(url()->current()); ?>"><svg
                                                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                                                            <path
                                                                d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z" />
                                                        </svg></a><a class="link"
                                                        href="https://t.me/share/url?url=<?php echo e(url()->current()); ?>"><svg
                                                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512">
                                                            <path
                                                                d="M248 8C111 8 0 119 0 256S111 504 248 504 496 393 496 256 385 8 248 8zM363 176.7c-3.7 39.2-19.9 134.4-28.1 178.3-3.5 18.6-10.3 24.8-16.9 25.4-14.4 1.3-25.3-9.5-39.3-18.7-21.8-14.3-34.2-23.2-55.3-37.2-24.5-16.1-8.6-25 5.3-39.5 3.7-3.8 67.1-61.5 68.3-66.7 .2-.7 .3-3.1-1.2-4.4s-3.6-.8-5.1-.5q-3.3 .7-104.6 69.1-14.8 10.2-26.9 9.9c-8.9-.2-25.9-5-38.6-9.1-15.5-5-27.9-7.7-26.8-16.3q.8-6.7 18.5-13.7 108.4-47.2 144.6-62.3c68.9-28.6 83.2-33.6 92.5-33.8 2.1 0 6.6 .5 9.6 2.9a10.5 10.5 0 0 1 3.5 6.7A43.8 43.8 0 0 1 363 176.7z" />
                                                        </svg></a><a class="link"
                                                        href="http://twitter.com/share?text=<?php echo e($row->name); ?>                                            &url=<?php echo e(url()->current()); ?>"><svg
                                                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                                            <path
                                                                d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z" />
                                                        </svg></a></div>
                                            </div>
                                        </div><a target="__blank" href="<?php echo e(url('ads/actions/profile/' . $row->slug)); ?> "
                                            class="profile"><svg xmlns="http://www.w3.org/2000/svg" width="32"
                                                height="32" fill="#000000" viewBox="0 0 256 256">
                                                <path
                                                    d="M224,144v64a8,8,0,0,1-8,8H40a8,8,0,0,1-8-8V144a8,8,0,0,1,16,0v56H208V144a8,8,0,0,1,16,0Zm-101.66,5.66a8,8,0,0,0,11.32,0l40-40a8,8,0,0,0-11.32-11.32L136,124.69V32a8,8,0,0,0-16,0v92.69L93.66,98.34a8,8,0,0,0-11.32,11.32Z">
                                                </path>
                                            </svg>تحميل البروفايل</a><span class="profile d-md-none d-block"><small>رقم
                                                الترخيص :</small><?php echo e($row->license_number); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3"><?php echo $row->location; ?></div>
                </div>
            </div>
        </div>

        <div id="desc" class="mt-4">
            <div class="container">
                <div class="box px-0 mb-4 py-4 px-4">
                    <h5 class="box-title mb-0 float-right pr-0">وصف المنتج</h5><button
                        class="btn-toggle float-left mb-0"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                            <path
                                d="M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z" />
                        </svg></button>
                    <div class="clearfix"></div>
                    <hr>
                    <div class="box-body p-0"><?php echo e($row->desc); ?></div>
                </div>
            </div>
        </div>


        <div id="models" class="mt-4">
            <div class="container">
                <div class="box px-0 mb-4 py-4 px-4">
                    <h5 class="box-title mb-0 float-right pr-0">النماذج</h5><button
                        class="btn-toggle float-left mb-0"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                            <path
                                d="M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z" />
                        </svg></button>
                    <div class="clearfix"></div>
                    <div class="box-body p-0 mt-5">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="nav-item"><a class="nav-link <?php echo e($loop->index == 0 ? 'active' : ''); ?>"
                                        id="tab-<?php echo e($item->id); ?>" data-toggle="tab"
                                        href="#tab-item-<?php echo e($item->id); ?>" role="tab" aria-controls="home"
                                        aria-selected="true"><?php echo e($item->name); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="tab-pane pt-4 show <?php echo e($loop->index == 0 ? 'active' : ''); ?>"
                                    id="tab-item-<?php echo e($item->id); ?>" role="tabpanel" aria-labelledby="home-tab">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <div class="key d-inline-block font-weight-600">المساحة :</div>
                                            <div class="val d-inline-block"><?php echo e($item->area_in_metres); ?> م2</div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="key d-inline-block font-weight-600">غرفة نوم :</div>
                                            <div class="val d-inline-block"><?php echo e($item->room_numbers); ?></div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="key d-inline-block font-weight-600">حمام :</div>
                                            <div class="val d-inline-block"><?php echo e($item->bathrooms_numbers); ?></div>
                                        </div>
                                        <div class="col">
                                            <div class="key d-inline-block font-weight-600">السعر :</div>
                                            <div class="val d-inline-block set-price"
                                                data-price="<?php echo e(number_format($item->price, 0, '.', ',')); ?>

                                                ريال سعودي">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="model-image text-center"><img class="w-50 mt-4 radius"
                                            src="<?php echo e(largeAsset('ads-products/items/' . $item->image)); ?>" alt="">
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="attributes" class="mt-4">
            <div class="container">
                <div class="box px-0 mb-4 py-4 px-4">
                    <h5 class="box-title mb-0 float-right pr-0">سمات الوحدة</h5><button
                        class="btn-toggle float-left mb-0"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                            <path
                                d="M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z" />
                        </svg></button>
                    <div class="clearfix"></div>
                    <hr>
                    <div class="box-body p-0">
                        <div class="row">
                            <div class="col-md-4 col-6">
                                <div class="attribute-box">
                                    <h6 class="attribute-title font-weight-bold mt-3 mb-4">داخلية</h6>
                                    <div class="row">
                                        <?php $__currentLoopData = $row->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inside): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($inside->get_attr->attr_type == 'داخلية'): ?>
                                                <div class="col-md-6 attr-item"><?php echo e($inside->get_attr->name); ?></div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4 col-6">
                                <div class="attribute-box">
                                    <h6 class="attribute-title font-weight-bold mt-3 mb-4">خارجية</h6>
                                    <div class="row">
                                        <?php $__currentLoopData = $row->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inside): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($inside->get_attr->attr_type == 'خارجية'): ?>
                                                <div class="col-md-6 attr-item"><?php echo e($inside->get_attr->name); ?></div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="attribute-box">
                                            <h6 class="attribute-title font-weight-bold mt-3 mb-4">الموقع</h6>
                                            <div class="row">
                                                <?php $__currentLoopData = $row->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inside): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($inside->get_attr->attr_type == 'الموقع'): ?>
                                                        <div class="col-md-12 attr-item"><?php echo e($inside->get_attr->name); ?>

                                                        </div>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="attribute-box end-box">
                                            <h6 class="attribute-title font-weight-bold mt-3 mb-4">خدمات</h6>
                                            <div class="row">
                                                <?php $__currentLoopData = $row->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inside): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($inside->get_attr->attr_type == 'الخدمات'): ?>
                                                        <div class="col-md-12 attr-item"><?php echo e($inside->get_attr->name); ?>

                                                        </div>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php if($row->video_url != ''): ?>
            <div id="video" class="mt-4">
                <div class="container">
                    <div class="box px-0 mb-4 py-4 px-4">
                        <h5 class="box-title mb-0 float-right pr-0">فيديو المشروع</h5><button
                            class="btn-toggle float-left mb-0"><svg xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 512 512">
                                <path
                                    d="M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z" />
                            </svg></button>
                        <div class="clearfix"></div>
                        <hr>
                        <div class="box-body p-0"><a href="<?php echo e($row->video_url); ?>" data-fancybox data-small-btn="true">
                                <div class="video-overlay"><img
                                        src="<?php echo e(largeAsset('ads-products/' . $row->main_image)); ?>" alt="">
                                    <div class="overlay d-flex justify-content-center align-items-center">
                                        <div class="overlay-content text-center"><svg xmlns="http://www.w3.org/2000/svg"
                                                viewBox="0 0 384 512">
                                                <path
                                                    d="M73 39c-14.8-9.1-33.4-9.4-48.5-.9S0 62.6 0 80V432c0 17.4 9.4 33.4 24.5 41.9s33.7 8.1 48.5-.9L361 297c14.3-8.7 23-24.2 23-41s-8.7-32.2-23-41L73 39z" />
                                            </svg></div>
                                    </div>
                                </div>
                            </a></div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

    </main>


    <div id="contact" class="mt-4">
        <div class="container">
            <div class="box px-0 mb-4 py-4 px-4">
                <h5 class="box-title mb-0 float-right pr-0">سجل اهتمامك</h5><button
                    class="btn-toggle float-left mb-0"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                        <path
                            d="M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z" />
                    </svg></button>
                <div class="clearfix"></div>
                <hr>
                <div class="box-body p-0">



                    <div class="col-lg-12">
                        <form class="form validate" action="<?php echo e(route('request-ads-store')); ?>" method="POST">

                            <div class="result"></div>


                            <div class="form-group">
                                <label class="required"><?php echo e(mainTrans('contact.name')); ?></label>
                                <input type="text" name="name" id="" class="input-main radius-sm"
                                    required />
                            </div>
                            <!-- Name -->

                            <?php echo csrf_field(); ?>

                            <div class="form-group">
                                <label class="required">رقم الهاتف</label>
                                <input type="phone" name="phone" id="" class="input-main radius-sm"
                                    required />
                            </div>
                            <!-- Email -->

                            <div class="form-group d-none">
                                <input type="hidden" name="subject" value="استفسار حول اعلان : <?php echo e($row->name); ?>"
                                    required />
                            </div>
                            <!-- subject -->


                            <div class="form-group">
                                <label><?php echo e(mainTrans('contact.message')); ?></label>
                                <textarea name="message" class="input-main radius-sm" id="" cols="30" rows="5"></textarea>
                            </div>
                            <!-- Message -->


                            <button type="submit" class="btn btn-main btn-block px-4 animated-button"
                                style="color:<?php echo e($row->navbar_color); ?> !important;"><?php echo e(mainTrans('contact.send_message')); ?></button>
                        </form>





                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer style="margin-top: 75px">
        <div style="background-color: <?php echo e($row->navbar_bg); ?>" class="text-center py-4">

            <div class="container">
                <div class="row">

                    <div class="col-md-6 text-center text-lg-right py-2">
                        <p class="mb-0" style="color: <?php echo e($row->navbar_color); ?>">جميع الحقوق محفوظة لشركة
                            <span style="color: <?php echo e($row->navbar_color); ?>"><u><?php echo e(env('APP_NAME')); ?></u></span>
                            <?php echo e(date('Y')); ?>

                        </p>
                    </div>



                    <div class="col-md-6 text-center text-lg-left py-2">
                        <a style="color: <?php echo e($row->navbar_color); ?>" href="<?php echo e(url('privacy-policy')); ?>">

                            <svg width="16px" fill="<?php echo e($row->navbar_color); ?>" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 512 512">
                                <path
                                    d="M256 0c4.6 0 9.2 1 13.4 2.9L457.7 82.8c22 9.3 38.4 31 38.3 57.2c-.5 99.2-41.3 280.7-213.6 363.2c-16.7 8-36.1 8-52.8 0C57.3 420.7 16.5 239.2 16 140c-.1-26.2 16.3-47.9 38.3-57.2L242.7 2.9C246.8 1 251.4 0 256 0zm0 66.8l0 378.1C394 378 431.1 230.1 432 141.4L256 66.8s0 0 0 0z" />
                            </svg>

                            سياسة الخصوصية


                        </a>

                    </div>



                </div>

            </div>


        </div>


    </footer>


    <?php if(setting()->phone != null): ?>
        <div class="fixed-phone">
            <a target="__blank" href="<?php echo e(url('ads/actions/call/' . $row->slug)); ?>"><img
                    src="<?php echo e(asset('assets/images/telephone.svg')); ?>" alt=""></a>
        </div>
    <?php endif; ?>

    <?php if(setting()->whatsapp != null): ?>
        <div class="fixed-whatsapp">
            <a target="__blank" href="<?php echo e(url('ads/actions/whats/' . $row->slug)); ?>"><img
                    src="<?php echo e(asset('assets/images/whatsapp.svg')); ?>" alt=""></a>
        </div>
    <?php endif; ?>



<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('assets/plugins/ticker/ticker-news.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"
        integrity="sha512-uURl+ZXMBrF4AwGaWmEetzrd+J5/8NRkWAvJx5sbPSSuOb0bZLqf+tOzniObO00BjHa/dD7gub9oCGMLPQHtQA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>


    <script>
        $(function() {
            var timer = !1;
            _Ticker = $("#T1").newsTicker({
                direction: 'rtl' // إذا كانت المكتبة تدعم RTL
            });
            _Ticker.on("mouseenter", function() {
                var __self = this;
                timer = setTimeout(function() {
                    __self.pauseTicker();
                }, 200);
            });
            _Ticker.on("mouseleave", function() {
                clearTimeout(timer);
                if (!timer) return !1;
                this.startTicker();
            });
        });


        $(".gallery .owl-carousel").owlCarousel({
            loop: !1,
            autoplay: !0,
            autoplayTimeout: 4e3,
            autoplaySpeed: 2e3,
            smartSpeed: 1e3,
            autoplayHoverPause: !0,
            margin: 20,
            nav: !1,
            responsive: {
                0: {
                    items: 3
                },
                600: {
                    items: 4
                },
                1e3: {
                    items: 6
                }
            }
        }), $(".btn-toggle").click(function(e) {
            e.preventDefault();
            $(this).parent(".box").find(".box-body").slideToggle(250)
        }), $(".share").click(function(e) {
            e.preventDefault(), $(".parnet-links").fadeToggle(100)
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('main.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\wjhatna\resources\views/main/products/ads.blade.php ENDPATH**/ ?>