<?php

use App\Http\Controllers\CityController;
use App\Http\Controllers\Dashboard\Admin\AdminController;
use App\Http\Controllers\Dashboard\Admin\PortfolioController;
use App\Http\Controllers\Dashboard\Admin\ProfileController;
use App\Http\Controllers\Dashboard\Auth\ForgetController;
use App\Http\Controllers\Dashboard\Auth\LoginController;
use App\Http\Controllers\Dashboard\Auth\LogoutController;
use App\Http\Controllers\Dashboard\Auth\ResetPasswordController;
use App\Http\Controllers\Dashboard\HomeController;
use App\Http\Controllers\Dashboard\RoleAndPermission\PermissionController;
use App\Http\Controllers\Dashboard\RoleAndPermission\RoleController;
use App\Http\Controllers\Dashboard\Settings\SettingController;
use App\Http\Controllers\InterestController;
use App\Http\Controllers\NeighborhoodController;
use App\Http\Controllers\Properties\PropertiesController;
use App\Http\Controllers\Properties\PropertyAattachmentsController;
use App\Http\Controllers\Properties\PropertyUnitsController;
use App\Http\Controllers\Property\AmenitiesController;
use App\Http\Controllers\Property\FeaturesController;
use App\Http\Controllers\Property\FurnishingController;
use App\Http\Controllers\Property\StatusController;
use Illuminate\Support\Facades\Route;

// Guest
Route::middleware('guest')->group(function () {

    Route::controller(LoginController::class)->group(function () {
 
        Route::get('login', 'index');
        Route::post('login', 'login')->name("login");
    });

    Route::controller(ForgetController::class)->group(function () {
        Route::get('forgot-passowrd', 'showLinkRequestForm')->name('password.request');
        Route::post('forgot-password', 'sendResetLinkEmail')->name('password.email');
    });

    Route::controller(ResetPasswordController::class)->group(function () {
        Route::get('reset-password/{token}', 'showResetForm')->name('password.reset');
        Route::post('reset-password', 'reset')->name('password.update');
    });

});

Route::prefix(adminPrefix())->group(function () {

    /**
     * Admin Middleware
     */
    Route::middleware(['AdminAuth'])->group(function () {


        Route::controller(InterestController::class)->prefix('interests')->name('interests.')->group(function () {
            // All
            Route::get('', 'index')->name('index');
            // Create
            Route::post('store', 'store')->name("store");
            // Update
            Route::patch('update', 'update')->name("update");
            // Destroy
            Route::delete('destroy', 'destroy')->name('destroy');
            Route::post('read/{id}', 'markAsRead')->name('read');

        }); // End


        /*
        |
        | properties | attachments
        |
        */
        Route::prefix('properties')->name('properties.')->group(function () {

            Route::controller(PropertiesController::class)->group(function () {

                // All
                Route::get('', 'index')->name('index');
                // Create
                Route::get('create', 'create')->name("create");
                Route::post('store', 'store')->name("store");

                // Update
                Route::get('edit/{id}', 'edit')->name("edit");
                Route::patch('update', 'update')->name("update");
                // Destroy
                Route::delete('destroy', 'destroy')->name('destroy');

            });

            Route::controller(PropertyAattachmentsController::class)->name('attachments.')->group(function () {
                // Route::get('upload-attachments/{id}', 'upload_attachments')->name("index");
                Route::post('store-attachment', 'store')->name('upload');
                Route::delete('destroy-attachment', 'destroy')->name('destroy');
            });

            Route::controller(PropertyUnitsController::class)->name('units.')->group(function () {
                Route::post('store-units', 'store')->name('store');
                Route::post('get-unit-row', 'getRow')->name('get_unit');
                Route::post('update-unit', 'update')->name('update');
                Route::delete('destroy-unit', 'destroy')->name('destroy');
            });

        });

        /*
        |
        | Admins & Profile
        |
         */
        Route::prefix('profile')->group(function () { // Admin Profile

            // Profile
            Route::controller(ProfileController::class)->group(function () {

                Route::get('show/{id?}', 'show'); // Show Profile
                Route::get('edit', 'edit');

                // Update
                Route::patch('update-personal-data', 'updatePersonalData')->name('update-personal-data');
                Route::patch('change-password', 'changeProfilePassword')->name('change-profile-password');

                /**
                 * Not Complate
                 */
                Route::post('experience', 'experience')->name('experience');
                /**
                 * Not Complate
                 */

                Route::patch('update-avatar', 'updateProfileAvatar')->name('update-profile-avatar');
                Route::patch('update-cover', 'updateProfileCover')->name('update-profile-cover');

                /**
                 * Not Complate
                 */
                // Delete Experience
                Route::delete('delete-experience', 'destroyExperience');

                Route::delete('delete-admin', 'deleteAdmin')->name('deleteAdmin');
                /**
                 * Not Complate
                 */

                // Verified Email
                Route::post('verify-email', 'sendMailForVerifyEmail')->name('sendMailForVerifyEmail');
                Route::get('verified-email/{token}', 'verifiedEmail');

                                                                                                     // Forgot Password
                Route::post('forgot-password', 'forgotPassword');                                    // Send Mail
                Route::get('reset-password/{token}', 'resetPasswordView');                           // View To Reset
                Route::patch('reset-password', 'resetPasswordUpdate')->name('reset-admin-password'); // Update

                // Update Roles
                Route::patch('change-roles', 'changeRoles')->name('change-roles');
            });

            // Portfolio
            Route::controller(PortfolioController::class)->group(function () {
                Route::patch('portfolio-update', 'update')->name('portfolio-update');
            });
        });

        Route::prefix('admins')->group(function () {

            Route::controller(AdminController::class)->group(function () {
                Route::get('', 'index');
                Route::post('search', 'search')->name("admin-search");
                // Create New Admin
                Route::get('create', 'create')->name("admin-create");
                Route::post('store', 'store')->name("create-admin");

                // Status
                Route::patch('closed-account', 'closedAccount')->name("closed-admin-account");
                Route::patch('active-account', 'activeAccount')->name("active-admin-account");

                // Global Actions From Admins By Owner
                Route::middleware('role:' . owner())->group(function () {
                    Route::delete('destroy', 'destroy')->name("delete-admin");
                });
            });

            Route::middleware('role:' . owner())->group(function () {
                // Edit
                Route::get('edit/{id}', [ProfileController::class, 'edit']);
                // Chnage Other Admin Password By Owner
                Route::patch('change-admin-password', [AdminController::class, 'changeAdminPassword'])->name("change-admin-password");
            });
        });

        /*
        |
        | settings
        |
         */
        Route::prefix('settings')->group(function () {

            Route::controller(SettingController::class)->group(function () {
                Route::get('', 'index');
                Route::post('store', 'store')->name('store-settings');

                Route::prefix('general')->group(function () {
                    Route::get('', 'indexGeneral');
                }); // general

            });

        });

        /*
        |
        | Neighborhoods
        |
        */
        Route::controller(NeighborhoodController::class)->prefix('neighborhoods')->name('neighborhood.')->group(function () {
            // All
            Route::get('', 'index')->name('index');
            // Create
            Route::post('store', 'store')->name("store");
            // Update
            Route::patch('update', 'update')->name("update");
            // Destroy
            Route::delete('destroy', 'destroy')->name('destroy');
            //
            Route::post('get', 'getNeighborhoods')->name("get");

        });

        /*
        |
        | Cities
        |
        */
        Route::controller(CityController::class)->prefix('cities')->name('city.')->group(function () {
            // All
            Route::get('', 'index')->name('index');
            // Create
            Route::post('store', 'store')->name("store");
            // Update
            Route::patch('update', 'update')->name("update");
            // Destroy
            Route::delete('destroy', 'destroy')->name('destroy');
        });

        Route::name('property.')->group(function () {

            Route::controller(StatusController::class)->prefix('property-status')->name('status.')->group(function () {
                // All
                Route::get('', 'index')->name('index');
                // Create
                Route::post('store', 'store')->name("store");
                // Update
                Route::patch('update', 'update')->name("update");
                // Destroy
                Route::delete('destroy', 'destroy')->name('destroy');
            });

            Route::controller(FurnishingController::class)->prefix('property-furnishing')->name('furnishing.')->group(function () {
                // All
                Route::get('', 'index')->name('index');
                // Create
                Route::post('store', 'store')->name("store");
                // Update
                Route::patch('update', 'update')->name("update");
                // Destroy
                Route::delete('destroy', 'destroy')->name('destroy');
            });

            Route::controller(FeaturesController::class)->prefix('property-features')->name('features.')->group(function () {
                // All
                Route::get('', 'index')->name('index');
                // Create
                Route::post('store', 'store')->name("store");
                // Update
                Route::patch('update', 'update')->name("update");
                // Destroy
                Route::delete('destroy', 'destroy')->name('destroy');
            });

            Route::controller(AmenitiesController::class)->prefix('property-amenities')->name('amenities.')->group(function () {
                // All
                Route::get('', 'index')->name('index');
                // Create
                Route::post('store', 'store')->name("store");
                // Update
                Route::patch('update', 'update')->name("update");
                // Destroy
                Route::delete('destroy', 'destroy')->name('destroy');
            });

        }); // End

        /*
        |
        | Roles & Permissions
        |
        */
        Route::controller(PermissionController::class)->group(function () {
            Route::prefix('permissions')->group(function () {
                Route::post('update', 'update')->name("update-permissions");
                Route::get('{id}', 'index');
            });
        });

        Route::controller(RoleController::class)->group(function () {
            Route::prefix('roles')->group(function () {
                Route::get('', 'index');
                Route::post('store', 'store')->name("store-role");
                Route::post('update', 'update')->name("update-role");
                Route::delete('destroy', 'destroy')->name('role-destroy');
            });
        });

        // Logout
        Route::post('logout', [LogoutController::class, 'logout'])->name("logout");
        // Home
        Route::controller(HomeController::class)->group(function () {
            Route::get('home', 'index');
        });

    }); // AdminAuth

}); // end adminPrefix()
