@extends('main.layouts.master')
@section('title', $row->title)
@section('meta')
    <meta name="title" content="{{ $row->title }}">
    <meta name="description" content="{{ Str::limit(strip_tags($row->description), 160) }}">
    <meta name="keywords"
        content="{{ $row->title }}, عقارات, {{ optional($row->city)->name }}, {{ optional($row->neighborhood)->name }}">
    {{-- Open Graph / Facebook --}}
    <meta property="og:type" content="article">
    <meta property="og:title" content="{{ $row->title }}">
    <meta property="og:description" content="{{ Str::limit(strip_tags($row->description), 160) }}">
    <meta property="og:image" content="{{ mediumAsset('properties/' . $row->main_image) }}">
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:site_name" content="{{ config('app.name') }}">
    {{-- Twitter --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $row->title }}">
    <meta name="twitter:description" content="{{ Str::limit(strip_tags($row->description), 160) }}">
    <meta name="twitter:image" content="{{ mediumAsset('properties/' . $row->main_image) }}">
@endsection
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/plugins/owl-carousel/owl.carousel.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/pages/property/show.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.css" />
@endsection
@section('content')


    <!-- Header bar -->
    <div id="header-bar" class="py-2">
        <div class="container d-flex align-items-center justify-content-between flex-wrap">
            <div class="d-flex flex-column">
                <h1 class=" mb-1">{{ $row->title }}</h1>
                <div class="meta-mini d-none d-md-block">
                    <span class="badge-dot">{{ $row->city?->name }} — {{ $row->neighborhood?->name }}</span>
                </div>
            </div>
            <div class="text-nowrap my-2 d-flex align-items-center">

                <span class="price-badge">
                    {{ number_format($row->price) }}
                    <span class="currency-icon">{!! currency_icon() !!}</span>
                </span>

                <div class="meta-mini mr-3 d-block d-md-none">
                    <span class="badge-dot">{{ $row->city?->name }} — {{ $row->neighborhood?->name }}</span>
                </div>

            </div>
        </div>
    </div>

    <header id="gallery" class="section-gap">
        <div class="container">
            <a href="{{ propertyImage($row->main_image, 'large') }}" data-fancybox="group" data-caption="">
                <img class="main-img cursor-zoom-in" src="{{ propertyImage($row->main_image, 'large') }}" alt="">
            </a>

            @if (count($row->attachments))
                <section id="more-images" class="mt-2">
                    <div class="owl-carousel">
                        @foreach ($row->attachments as $img)
                            <div class="item">
                                <a href="{{ propertyImage('attachments/' . $img->attachment_name, 'large') }}"
                                    data-fancybox="group" data-caption="">
                                    <img src="{{ propertyImage('attachments/' . $img->attachment_name, 'small') }}"
                                        loading="lazy" alt="">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </section>
            @endif
        </div>
    </header>

    @if ($row->description)
        <section id="desc" class="section-gap">
            <div class="container">
                <div class="box p-0">
                    <h4 class="section-title px-4 mb-0">الوصف</h4>
                    <div class="px-4 pb-4 pt-2">
                        @php
                            $desc = $row->description;
                            $short = mb_substr($desc, 0, 220);
                            $hasMore = mb_strlen($desc) > 220;
                        @endphp

                        <div class="description">
                            {!! nl2br(e($short)) !!}
                            @if ($hasMore)
                                <span class="dots">...</span>
                                <span class="more d-none">{!! nl2br(e(mb_substr($desc, 220))) !!}</span>
                                <div class="read-more mt-2">
                                    <a href="javascript:void(0)" class="show-more text-primary">عرض المزيد</a>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif


    <div id="models" class="mt-4">
        <div class="container">
            <div class="box p-0">
                <h4 class="section-title px-4 mb-0">النماذج</h4>

                <div class="px-4 pb-4 pt-2">

                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        @foreach ($row->units as $item)
                            <li class="nav-item"><a class="nav-link {{ $loop->index == 0 ? 'active' : '' }}"
                                    id="tab-{{ $item->id }}" data-toggle="tab" href="#tab-item-{{ $item->id }}"
                                    role="tab" aria-controls="home" aria-selected="true">{{ $item->name }}</a></li>
                        @endforeach
                    </ul>

                    <div class="tab-content" id="myTabContent">
                        @foreach ($row->units as $item)
                            <div class="tab-pane pt-4 show {{ $loop->index == 0 ? 'active' : '' }}"
                                id="tab-item-{{ $item->id }}" role="tabpanel" aria-labelledby="home-tab">
                                <div class="row">
                                    <div class="col-md-2 col-6 mb-2 mb-md-0">
                                        <div class="label d-inline-block">المساحة</div>
                                        <div class="value d-inline-block">{{ $item->area }} م²</div>
                                    </div>
                                    <div class="col-md-2 col-6 mb-2 mb-md-0">
                                        <div class="label d-inline-block">عدد الغرف</div>
                                        <div class="value d-inline-block">{{ $item->bedrooms }}</div>
                                    </div>
                                    <div class="col-md-2 col-6 ">
                                        <div class="label d-inline-block">عدد الحمامات</div>
                                        <div class="value d-inline-block">{{ $item->bathrooms }}</div>
                                    </div>
                                    <div class="col">
                                        <div class="label d-inline-block ">السعر</div>
                                        <div class="value d-inline-block">
                                            <span class="price-badge">
                                                {{ number_format($item->price) }}
                                                <span class="currency-icon">{!! currency_icon() !!}</span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="model-image">
                                    <img class=" mt-3 radius" src="{{ largeAsset('properties/units/' . $item->image) }}"
                                        alt="" loading="lazy">
                                </div>
                            </div>
                        @endforeach
                    </div>

                </div>
            </div>
        </div>
    </div>



    <section id="details" class="details section-gap">
        <div class="container">
            <div class="box p-0">
                <h4 class="section-title px-4 mb-0">التفاصيل</h4>
                <div class="px-4 pb-4 pt-2">
                    <div class="row">
                        @foreach ($details as $item)
                            @php $has = filled($item['value']); @endphp
                            @if ($has)
                                <div class="col-lg-4 col-sm-6 col-12 mb-2">
                                    <div class="detail-chip">
                                        <span class="icon">{!! $item['icon'] !!}</span>
                                        <span class="label">{{ $item['name'] }}</span>
                                        <span class="value ml-auto">
                                            {{ $item['value'] }}@if ($item['text'])
                                                <small>{{ $item['text'] }}</small>
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>

    @if ($row->google_map_iframe)
        <section id="location" class="section-gap">
            <div class="container">
                <div class="box p-0">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="section-title px-4 mb-0 ">الموقع</h4>
                        <div class="px-4 meta-mini d-none d-sm-block pt-2 ">{{ $row->city?->name }} —
                            {{ $row->neighborhood?->name }}</div>
                    </div>
                    <div class="px-4 pb-4 pt-2">
                        {!! $row->google_map_iframe !!}

                    </div>
                </div>
            </div>
        </section>
    @endif

    @if (count($row->features) > 0)
        <section id="features" class="section-gap">
            <div class="container">
                <div class="box p-0">
                    <h4 class="section-title px-4 mb-0">المميزات</h4>
                    <div class="px-4 pb-4 pt-2">
                        <div class="row">
                            @foreach ($row->features as $feature)
                                <div class="col-md-4 col-sm-6 col-12 mb-2">
                                    <div class="feature-item">
                                        <span class="icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                                fill="#000000" viewBox="0 0 256 256">
                                                <path
                                                    d="M176.49,95.51a12,12,0,0,1,0,17l-56,56a12,12,0,0,1-17,0l-24-24a12,12,0,1,1,17-17L112,143l47.51-47.52A12,12,0,0,1,176.49,95.51ZM236,128A108,108,0,1,1,128,20,108.12,108.12,0,0,1,236,128Zm-24,0a84,84,0,1,0-84,84A84.09,84.09,0,0,0,212,128Z">
                                                </path>
                                            </svg>
                                        </span>
                                        <span class="font-weight-500">{{ $feature->name }}</span>
                                    </div>
                                </div>
                            @endforeach
                            @if (!count($row->features))
                                <div class="col-12 text-center text-muted">—</div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif

    @if (count($row->amenities) > 0)
        <section id="amenities" class="section-gap mb-5">
            <div class="container">
                <div class="box p-0">
                    <h4 class="section-title px-4 mb-0">وسائل الراحة</h4>
                    <div class="px-4 pb-4 pt-2">
                        <div class="row">
                            @foreach ($row->amenities as $amenitie)
                                <div class="col-md-4 col-sm-6 col-12 mb-2">
                                    <div class="feature-item">
                                        <span class="icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                                fill="#000000" viewBox="0 0 256 256">
                                                <path
                                                    d="M176.49,95.51a12,12,0,0,1,0,17l-56,56a12,12,0,0,1-17,0l-24-24a12,12,0,1,1,17-17L112,143l47.51-47.52A12,12,0,0,1,176.49,95.51ZM236,128A108,108,0,1,1,128,20,108.12,108.12,0,0,1,236,128Zm-24,0a84,84,0,1,0-84,84A84.09,84.09,0,0,0,212,128Z">
                                                </path>
                                            </svg>
                                        </span>
                                        <span class="font-weight-500">{{ $amenitie->name }}</span>
                                    </div>
                                </div>
                            @endforeach
                            @if (!count($row->amenities))
                                <div class="col-12 text-center text-muted">—</div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif


    <footer>
        <div class="container">
            <div class=" text-center">
                <img width="128px" src="{{ website_logo() }}" alt="">
                <div class="row justify-content-center">
                    <div class="col-lg-7 col-md-9">
                        <p class="text-white mt-3">{{ $settings->website_desc }}</p>

                        <div id="social-links" class="mb-4 mb-md-0">
                            <ul class="list-unstyled d-flex flex-row flex-wrap justify-content-center">
                                @foreach (mainViewSocialMedia() as $key => $val)
                                    @php $valName = $val['name_en']; @endphp
                                    @if (!empty($settings[$valName]))
                                        <li>
                                            <a class="text-white px-2" target=_blank
                                                href="{{ $settings[$valName] }}">{!! $val['icon'] !!}
                                            </a>
                                        </li>
                                    @endif
                                @endforeach
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </footer>
@endsection
@section('js')
    <script src="{{ asset('assets/plugins/owl-carousel/owl.carousel.min.js') }}"></script>
    <script>
        $(function() {
            $('.show-more').on('click', function() {
                var $btn = $(this);
                var $wrap = $btn.closest('.description');
                $wrap.find('.more').toggleClass('d-none');
                $wrap.find('.dots').toggleClass('d-none');
                $btn.text($btn.text().trim() === 'عرض المزيد' ? 'إخفاء' : 'عرض المزيد');
            });


        });

        if ($('.owl-carousel').length) {
            $("#more-images .owl-carousel").owlCarousel({
                loop: false,
                margin: 8,
                nav: false,
                dots: false,
                autoplay: true,
                autoplayTimeout: 4000,
                autoplaySpeed: 1000,
                smartSpeed: 1000,
                autoplayHoverPause: true,
                rtl: true,
                responsive: {
                    0: {
                        items: 3,
                    },
                    500: {
                        items: 4,
                    },
                    1000: {
                        items: 6,
                    },
                },
            });
        }
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.js"></script>
@endsection
