@extends('dashboard.layouts.master')
@section('title', 'التعديل علي | ' . $row->title)
<x-dashboard.css :links="[
    [
        'link' => 'products/products.css',
    ],
]" />
@section('content')

    <x-dashboard.links-bar :links="[
        [
            'name' => $page_title,
            'link' => route('properties.index'),
        ],
        [
            'name' => Str::limit($row->title, 50),
        ],
    ]" />

    <section class="mb-5">
        <div class="row">


            <div class="col-md-3">
                <div class="box">
                    @foreach ($tabs as $tabKey => $tabVal)
                        <a href="?section={{ $tabKey }}"
                            class="btn btn-block @if ($tabKey == $section) {{ 'btn-second' }}@else{{ 'btn-light' }} @endif ">{{ $tabVal['name'] }}</a>
                    @endforeach
                </div>
            </div><!-- tabs -->

            <div class="col-md-9">
                @switch($section)
                    @case('main-info')
                        <form id="update-form" class="form validate" action="{{ route('properties.update') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PATCH')

                            <x-panel-with-heading title="البيانات الرئيسية">
                                <div class="row">

                                    <div class="col-md-12">
                                        <x-form-group :properties="[
                                            'input' => [
                                                'name' => 'main_image',
                                                'type' => 'file',
                                                'options' => ['class' => 'input-img', 'accept' => 'image/*'],
                                            ],
                                            'label' => [
                                                'text' => 'الصورة الرئيسية',
                                            ],
                                        ]" />
                                    </div><!-- main_image -->

                                    <div class="col-md-8">
                                        <x-form-group :properties="[
                                            'input' => [
                                                'name' => 'title',
                                                'type' => 'text',
                                                'value' => $row->title,
                                                'options' => ['required'],
                                            ],
                                            'label' => [
                                                'text' => 'عنوان العقار / الاعلان',
                                                'options' => [
                                                    'class' => 'required',
                                                ],
                                            ],
                                        ]" />
                                    </div><!-- title -->

                                    <div class="col-md-2">
                                        <x-form-group :properties="[
                                            'input' => [
                                                'name' => 'price',
                                                'type' => 'number',
                                                'value' => $row->price,
                                                'options' => [
                                                    'required',
                                                    'class' => 'ltr text-center',
                                                    'step' => 'any',
                                                ],
                                            ],
                                            'label' => [
                                                'text' => 'السعر ( ر.س )',
                                                'options' => [
                                                    'class' => 'required',
                                                ],
                                            ],
                                        ]" />
                                    </div><!-- price -->

                                    <div class="col-md-2">
                                        <x-form-group :properties="[
                                            'input' => [
                                                'name' => 'area',
                                                'type' => 'number',
                                                'value' => $row->area,
                                                'options' => [
                                                    'required',
                                                    'class' => 'ltr text-center',
                                                    'step' => 'any',
                                                    'min' => 0,
                                                ],
                                            ],
                                            'label' => [
                                                'text' => 'المساحة م²',
                                                'options' => [
                                                    'class' => 'required',
                                                ],
                                            ],
                                        ]" />
                                    </div><!-- area -->

                                    <div class="col-md-4">
                                        <x-form-group :properties="[
                                            'select' => [
                                                'name' => 'city_id',
                                                'list' => $cities,
                                                'selected' => $row->city_id,
                                                'options' => [
                                                    'class' => 'select2',
                                                    'data-url-get-neighborhoods' => route('neighborhood.get'),
                                                ],
                                            ],
                                            'label' => [
                                                'text' => 'المدينة',
                                                'options' => [
                                                    'class' => 'required',
                                                ],
                                            ],
                                        ]" />
                                    </div><!-- city_id -->

                                    <div class="col-md-4">
                                        <x-form-group :properties="[
                                            'select' => [
                                                'name' => 'neighborhood_id',
                                                'selected' => $row->neighborhood_id,
                                                'list' => $neighborhoods,
                                                'options' => [
                                                    'class' => 'select2',
                                                    'required',
                                                ],
                                            ],
                                            'label' => [
                                                'text' => 'المنطقة',
                                                'options' => [
                                                    'class' => 'required',
                                                ],
                                            ],
                                        ]" />
                                    </div><!-- neighborhood_id -->

                                    <div class="col-md-4">
                                        <x-form-group :properties="[
                                            'select' => [
                                                'name' => 'property_type_id',
                                                'list' => $propertyTypes,
                                                'selected' => $row->property_type_id,
                                                'options' => ['required', 'placeholder' => 'حدد النوع'],
                                            ],
                                            'label' => [
                                                'text' => 'النوع',
                                                'options' => [
                                                    'class' => 'required',
                                                ],
                                            ],
                                        ]" />
                                    </div><!-- property_type_id -->

                                </div>
                            </x-panel-with-heading>

                            <x-panel-with-heading title="الوصف">
                                <x-form-group :properties="[
                                    'textarea' => [
                                        'name' => 'description',
                                        'type' => 'text',
                                        'value' => $row->description,
                                        'options' => [
                                            'rows' => 5,
                                            'placeholder' => 'قم بكتابة وصف للعقار / الاعلان بالكامل',
                                        ],
                                    ],
                                    'label' => [
                                        'text' => 'الوصف',
                                    ],
                                ]" /><!-- description -->
                            </x-panel-with-heading>

                            <x-panel-with-heading title="التفاصيل">
                                <div class="row">


                                    <div class="col-md-4">
                                        <x-form-group :properties="[
                                            'input' => [
                                                'name' => 'bathrooms',
                                                'type' => 'number',
                                                'value' => $row->bathrooms,
                                                'options' => [
                                                    'class' => 'ltr text-center',
                                                    'min' => 1,
                                                ],
                                            ],
                                            'label' => [
                                                'text' => $icons['bathrooms'] . ' عدد الحمامات',
                                            ],
                                        ]" />
                                    </div><!-- bathrooms -->

                                    <div class="col-md-4">
                                        <x-form-group :properties="[
                                            'input' => [
                                                'name' => 'bedrooms',
                                                'type' => 'number',
                                                'value' => $row->bedrooms,
                                                'options' => [
                                                    'class' => 'ltr text-center',
                                                    'min' => 1,
                                                ],
                                            ],
                                            'label' => [
                                                'text' => $icons['bedrooms'] . ' عدد الغرف',
                                            ],
                                        ]" />
                                    </div><!-- bedrooms -->

                                    <div class="col-md-4">
                                        <x-form-group :properties="[
                                            'input' => [
                                                'name' => 'floor',
                                                'type' => 'text',
                                                'value' => $row->floor,
                                            ],
                                            'label' => [
                                                'text' => $icons['floor_icon'] . ' الدور',
                                            ],
                                        ]" />
                                    </div><!-- floor -->

                                    <div class="col-md-4">
                                        <x-form-group :properties="[
                                            'input' => [
                                                'name' => 'front',
                                                'type' => 'text',
                                                'value' => $row->front,
                                                'options' => [
                                                    'placeholder' => 'واجهة امامية , بحرية , شمالية , ...',
                                                ],
                                            ],
                                            'label' => [
                                                'text' => 'الواجهة',
                                            ],
                                        ]" />
                                    </div><!-- front -->

                                    <div class="col-md-4">
                                        <x-form-group :properties="[
                                            'select' => [
                                                'name' => 'property_status_id',
                                                'list' => $propertyStatuses,
                                                'selected' => $row->property_status_id,
                                                'options' => ['placeholder' => 'حدد الغرض'],
                                            ],
                                            'label' => [
                                                'text' => 'الغرض',
                                            ],
                                        ]" />
                                    </div><!-- property_status_id -->

                                    <div class="col-md-4">
                                        <x-form-group :properties="[
                                            'select' => [
                                                'name' => 'furnishing_status_id',
                                                'list' => $furnishingStatuses,
                                                'selected' => $row->furnishing_status_id,
                                                'options' => ['placeholder' => 'اختر'],
                                            ],
                                            'label' => [
                                                'text' => 'مستوي التشطيب',
                                            ],
                                        ]" />
                                    </div><!-- furnishing_status_id -->

                                </div>
                            </x-panel-with-heading>

                            <x-panel-with-heading title="المميزات & الراحة">
                                <div class="row">

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>المميزات</label>
                                            <select name="feature_id[]" class="form-control select2-multiple" multiple>
                                                @foreach ($features as $feature)
                                                    <option value="{{ $feature->id }}"
                                                        {{ in_array($feature->id, $row->features->pluck('id')->toArray()) ? 'selected' : '' }}>
                                                        {{ $feature->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div><!-- feature_id -->

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>وسائل الراحة</label>
                                            <select name="amenity_id[]" class="form-control select2-multiple" multiple>
                                                @foreach ($amenities as $amenitie)
                                                    <option value="{{ $amenitie->id }}"
                                                        {{ in_array($amenitie->id, $row->amenities->pluck('id')->toArray()) ? 'selected' : '' }}>
                                                        {{ $amenitie->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div><!-- amenity_id -->


                                </div>
                            </x-panel-with-heading>

                            <x-panel-with-heading title="تضمين خريطة">
                                <x-form-group class="mb-1 pt-2" :properties="[
                                    'textarea' => [
                                        'name' => 'google_map_iframe',
                                        'value' => $row->google_map_iframe,
                                        'options' => [
                                            'rows' => '6',
                                            'class' => 'ltr',
                                        ],
                                    ],
                                ]" />
                                <small class=" text-muted">
                                    قم بالذهاب إلي <a target="__blank" href="https://www.google.com/maps">خرائط جوجل</a>
                                    وابحث عن المكان بعد ذلك
                                    قم بمشاركة الخريطة
                                    وانسخ المحتوي بداخل قسم
                                    تضمين خريطة
                                </small>
                            </x-panel-with-heading>

                            <button type="submit" class="btn btn-main px-5">تحديث</button>
                        </form><!-- End Form -->
                    @break

                    @case('gallery')
                        <section id="gallery">
                            <div id="uploader">

                                <form id="update-form" class="form-upload-attachments"
                                    action="{{ route('properties.attachments.upload') }}" method="POST"
                                    enctype="multipart/form-data">
                                    <div class="pb-5 box text-center">

                                        <input type="hidden" name="id" value="{{ $row->id }}">
                                        @csrf
                                        <x-form-group class="mb-0" :properties="[
                                            'input' => [
                                                'name' => 'upload[]',
                                                'type' => 'file',
                                                'options' => [
                                                    'multiple',
                                                    'required',
                                                    'accept' => 'image/*',
                                                    'class' => 'input-upload d-none',
                                                ],
                                            ],
                                        ]" />

                                        <div class="upload-icon  text-center ">
                                            <i class="fa-solid fa-arrow-up-from-bracket"></i>
                                        </div>

                                        <h5 class=" text-center mt-3">اختر صور للتحميل</h5>
                                        <small>( {{ 'اقصى حجم : ' . $maxSize . ' ميجابيت' }} </small>
                                        <small>|</small>
                                        <small>{{ 'الحد الأقصي : ' . $maxFiles . ' ملف' }} )</small>
                                        <br>
                                        <button id="btn-browse" class="btn btn-main cursor-pointer mt-3">تصفح
                                            المرفقات</button>
                                    </div><!-- box -->

                                </form><!-- form Browse File -->


                            </div><!-- col -->

                            <div class="row">

                                <div class="col-12">
                                    <h5 class="mb-3">الصور المتاحة</h5>
                                </div>
                                @forelse ($row->attachments as $id => $attachment)
                                    <div class="col-md-2 gallery-image-box  parents">
                                        <div class="box p-1">
                                            <img class="w-100 object-cover"
                                                src="{{ smallAsset('properties/attachments/' . $attachment->attachment_name) }}"
                                                alt="">
                                        </div>
                                        <form class="ajax-delete d-inline-block"
                                            action="{{ route('properties.attachments.destroy') }}" method="POST">
                                            @method('DELETE')
                                            @csrf
                                            <input type="hidden" class="id" name="id" value="{{ $attachment->id }}">
                                            <button type="submit" data-delete="هل تريد حذف الصورة ؟"
                                                class="btn-delete-attech  btn-sm btn btn-danger"><i class=" fa fa-trash-alt"></i>
                                            </button>
                                        </form>
                                    </div>

                                @empty
                                    <div class="col-12">
                                        <div class="alert alert-warning">
                                            <p class=" text-center mb-0 font-weight-700">لم يتم رفع صورة إلي هذه الإعلان العقاري</p>
                                        </div>
                                    </div>
                                @endforelse
                            </div><!--  -->

                        </section>
                    @break

                    @case('items')
                        <x-panel-with-heading title="اضافة نموذج جديد">
                            <form id="update-form" class="form validate" action="{{ route('properties.units.store') }}"
                                method="POST" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="item_id" value="">
                                <div class="row">

                                    <div class="col-md-8">
                                        <div class="row">

                                            <div class="col-md-12">
                                                <x-form-group :properties="[
                                                    'input' => [
                                                        'name' => 'name',
                                                        'type' => 'text',
                                                        'options' => [
                                                            'required',
                                                            'placeholder' => 'مثال : A, B, C, D, E, F,...',
                                                        ],
                                                    ],
                                                    'label' => [
                                                        'text' => 'اسم النموذج',
                                                        'options' => [
                                                            'class' => 'required',
                                                        ],
                                                    ],
                                                ]" />
                                            </div><!-- name -->

                                            <div class="col-6">
                                                <x-form-group :properties="[
                                                    'input' => [
                                                        'name' => 'area',
                                                        'type' => 'number',
                                                        'options' => ['required', 'class' => 'font-18 text-center'],
                                                    ],
                                                    'label' => [
                                                        'text' => 'المساحة م²',
                                                        'options' => [
                                                            'class' => 'required',
                                                        ],
                                                    ],
                                                ]" />
                                            </div><!-- area -->

                                            <div class="col-6">
                                                <x-form-group :properties="[
                                                    'input' => [
                                                        'name' => 'price',
                                                        'type' => 'number',
                                                        'options' => [
                                                            'required',
                                                            'step' => 'any',
                                                            'class' => 'font-18 text-center',
                                                        ],
                                                    ],
                                                    'label' => [
                                                        'text' => 'السعر ( ر.س )',
                                                        'options' => [
                                                            'class' => 'required',
                                                        ],
                                                    ],
                                                ]" />
                                            </div><!-- price -->

                                            <div class="col-6">
                                                <x-form-group :properties="[
                                                    'input' => [
                                                        'name' => 'bedrooms',
                                                        'type' => 'number',
                                                        'options' => ['required', 'class' => 'font-18 text-center'],
                                                    ],
                                                    'label' => [
                                                        'text' => 'عدد الغرف',
                                                        'options' => [
                                                            'class' => 'required',
                                                        ],
                                                    ],
                                                ]" />
                                            </div><!-- bedrooms -->

                                            <div class="col-6">
                                                <x-form-group :properties="[
                                                    'input' => [
                                                        'name' => 'bathrooms',
                                                        'type' => 'number',
                                                        'options' => ['required', 'class' => 'font-18 text-center'],
                                                    ],
                                                    'label' => [
                                                        'text' => 'عدد الحمامات',
                                                        'options' => [
                                                            'class' => 'required',
                                                        ],
                                                    ],
                                                ]" />
                                            </div><!-- bathrooms -->

                                        </div><!-- end row -->

                                        <button type="submit" class="btn btn-main">اضافة</button>
                                    </div><!-- end grid 8 -->

                                    <div class="col-md-4 item-image-input">

                                        <x-form-group :properties="[
                                            'input' => [
                                                'name' => 'image',
                                                'type' => 'file',
                                                'options' => [
                                                    'class' => 'input-img',
                                                    'accept' => 'image/*',
                                                ],
                                            ],
                                            'label' => [
                                                'text' => 'صورة للنموذج',
                                            ],
                                        ]" /><!-- image -->

                                        <img class="item-edit-image img img-fluid" src="" alt="">

                                    </div>

                                </div><!-- end row -->

                            </form><!-- End Form -->
                        </x-panel-with-heading>

                        <div class="box table-responsive">
                            <table class="table table-inverse mb-0  table-modern">
                                <thead class="thead-inverse">
                                    <tr>
                                        <th>التحكم</th>
                                        <th class=" text-center">صورة النموذج</th>
                                        <th>اسم النموذج</th>
                                        <th>المساحة</th>
                                        <th>السعر</th>
                                        <th>عدد الغرف</th>
                                        <th>عدد الحمامات</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($items as $item)
                                        <tr class="parents">
                                            <td>

                                                <button data-id="{{ $item->id }}" type="button"
                                                    class="btn-edit-item btn btn-sm btn-soft-primary">
                                                    <i class="fa fa-edit"></i>
                                                </button>

                                                <form class="ajax-delete d-inline-block"
                                                    action="{{ route('properties.units.destroy') }}" method="POST">
                                                    @method('DELETE')
                                                    @csrf
                                                    <input type="hidden" class="id" name="id"
                                                        value="{{ $item->id }}">
                                                    <button type="submit"
                                                        data-delete="{{ 'هل انت متأكد من حذف ' . $item->name }}"
                                                        class="btn btn-sm btn-soft-danger"><i
                                                            class="fa-solid fa-trash"></i></button>
                                                </form>

                                            </td><!-- actions -->
                                            <td class="text-center">
                                                @if ($item->image == '')
                                                    -
                                                @else
                                                    <img width="100px" height="50px" class="radius object-content"
                                                        src="{{ smallAsset('properties/units/' . $item->image) }}"
                                                        alt="">
                                                @endif
                                            </td><!-- image -->
                                            <td>{{ $item->name }}</td>
                                            <td>{{ $item->area }} م²</td>
                                            <td>{{ number_format($item->price) }} ر.س</td>
                                            <td>( {{ $item->bedrooms }} ) غرفة</td>
                                            <td>( {{ $item->bathrooms }} ) حمام</td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div><!-- box -->
                    @break

                    @default
                @endswitch
            </div>


        </div>
    </section><!-- Section -->
    <input type="hidden" form="update-form" value="{{ $row->id }}" name="id">
    <input type="hidden" form="update-form" value="{{ $section }}" name="section">



@endsection
<x-dashboard.js :links="[
    [
        'link' => 'properties/index.js',
        'type' => 'module',
    ],
    [
        'link' => 'image-preview',
        'from' => 'components',
    ],
]" />
