@extends('dashboard.layouts.master')
@section('title', 'اضافة جديد')
<x-dashboard.css :links="[
    [
        'link' => 'properties/index.css',
    ],
]" />
@section('content')


    <x-dashboard.links-bar :links="[
        [
            'name' => $page_title,
            'link' => route('properties.index'),
        ],
        [
            'name' => 'اضافة جديد',
        ],
    ]" /><!-- links bar  -->


    <main class="create-update-section mb-5 pb-5">
        <form class="form" action="{{ route('properties.store') }}" method="post" enctype="multipart/form-data">
            <div class="row justify-content-center">
                @csrf
                <div class="col-lg-9">

                    <x-panel-with-heading title="البيانات الرئيسية">
                        <div class="row">

                            <div class="col-md-12">
                                <x-form-group :properties="[
                                    'input' => [
                                        'name' => 'main_image',
                                        'type' => 'file',
                                        'options' => ['class' => 'input-img', 'accept' => 'image/*'],
                                    ],
                                    'label' => [
                                        'text' => 'الصورة الرئيسية',
                                    ],
                                ]" />
                            </div><!-- main_image -->

                            <div class="col-md-8">
                                <x-form-group :properties="[
                                    'input' => [
                                        'name' => 'title',
                                        'type' => 'text',
                                        'options' => ['required'],
                                    ],
                                    'label' => [
                                        'text' => 'عنوان العقار / الاعلان',
                                        'options' => [
                                            'class' => 'required',
                                        ],
                                    ],
                                ]" />
                            </div><!-- title -->

                            <div class="col-md-2">
                                <x-form-group :properties="[
                                    'input' => [
                                        'name' => 'price',
                                        'type' => 'number',
                                        'options' => ['required', 'class' => 'ltr text-center', 'step' => 'any'],
                                    ],
                                    'label' => [
                                        'text' => 'السعر ( ر.س )',
                                        'options' => [
                                            'class' => 'required',
                                        ],
                                    ],
                                ]" />
                            </div><!-- price -->

                            <div class="col-md-2">
                                <x-form-group :properties="[
                                    'input' => [
                                        'name' => 'area',
                                        'type' => 'number',
                                        'options' => [
                                            'required',
                                            'class' => 'ltr text-center',
                                            'step' => 'any',
                                            'min' => 0,
                                        ],
                                    ],
                                    'label' => [
                                        'text' => 'المساحة م²',
                                        'options' => [
                                            'class' => 'required',
                                        ],
                                    ],
                                ]" />
                            </div><!-- area -->

                            <div class="col-md-4">
                                <x-form-group :properties="[
                                    'select' => [
                                        'name' => 'city_id',
                                        'list' => $cities,
                                        'options' => [
                                            'class' => 'select2',
                                            'data-url-get-neighborhoods' => route('neighborhood.get'),
                                        ],
                                    ],
                                    'label' => [
                                        'text' => 'المدينة',
                                        'options' => [
                                            'class' => 'required',
                                        ],
                                    ],
                                ]" />
                            </div><!-- city_id -->

                            <div class="col-md-4">
                                <x-form-group :properties="[
                                    'select' => [
                                        'name' => 'neighborhood_id',
                                        'selected' => '',
                                        'text' => 'type',
                                        'options' => [
                                            'class' => 'select2',
                                            'required',
                                        ],
                                    ],
                                    'label' => [
                                        'text' => 'المنطقة',
                                        'options' => [
                                            'class' => 'required',
                                        ],
                                    ],
                                ]" />
                            </div><!-- neighborhood_id -->

                            <div class="col-md-4">
                                <x-form-group :properties="[
                                    'select' => [
                                        'name' => 'property_type_id',
                                        'list' => $propertyTypes,
                                        'selected' => '',
                                        'options' => ['required', 'placeholder' => 'حدد النوع'],
                                    ],
                                    'label' => [
                                        'text' => 'النوع',
                                        'options' => [
                                            'class' => 'required',
                                        ],
                                    ],
                                ]" />
                            </div><!-- property_type_id -->

                        </div>
                    </x-panel-with-heading>

                    
                    <x-panel-with-heading class="hide -body" title="الوصف">
                        <x-form-group class="mb-0 pt-2" :properties="[
                            'textarea' => [
                                'name' => 'description',
                                'type' => 'text',
                                'options' => [
                                    'rows' => 5,
                                    'placeholder' => 'قم بكتابة وصف للعقار / الاعلان بالكامل',
                                ],
                            ],
                        ]" /><!-- description -->
                    </x-panel-with-heading>

                    <x-panel-with-heading class="hide -body" title="التفاصيل">
                        <div class="row">

                            <div class="col-md-4">
                                <x-form-group :properties="[
                                    'input' => [
                                        'name' => 'bathrooms',
                                        'type' => 'number',
                                        'options' => [
                                            'class' => 'ltr',
                                            'class' => 'text-center',
                                            'min' => 1,
                                        ],
                                    ],
                                    'label' => [
                                        'text' => $icons['bathrooms'] . ' عدد الحمامات',
                                    ],
                                ]" />
                            </div><!-- bathrooms -->

                            <div class="col-md-4">
                                <x-form-group :properties="[
                                    'input' => [
                                        'name' => 'bedrooms',
                                        'type' => 'number',
                                        'options' => [
                                            'class' => 'ltr',
                                            'class' => 'text-center',
                                            'min' => 1,
                                        ],
                                    ],
                                    'label' => [
                                        'text' => $icons['bedrooms'] . ' عدد الغرف',
                                    ],
                                ]" />
                            </div><!-- bedrooms -->

                            <div class="col-md-4">
                                <x-form-group :properties="[
                                    'input' => [
                                        'name' => 'floor',
                                        'type' => 'text',
                                        'options' => [
                                            'class' => 'ltr',
                                        ],
                                    ],
                                    'label' => [
                                        'text' => $icons['floor_icon'] . ' الدور',
                                    ],
                                ]" />
                            </div><!-- floor -->

                            <div class="col-md-4">
                                <x-form-group :properties="[
                                    'input' => [
                                        'name' => 'front',
                                        'type' => 'text',
                                        'options' => [
                                            'placeholder' => 'واجهة امامية , بحرية , شمالية , ...',
                                        ],
                                    ],
                                    'label' => [
                                        'text' => 'الواجهة',
                                    ],
                                ]" />
                            </div><!-- front -->

                            <div class="col-md-4">
                                <x-form-group :properties="[
                                    'select' => [
                                        'name' => 'property_status_id',
                                        'list' => $propertyStatuses,
                                        'selected' => '',
                                        'options' => ['placeholder' => 'حدد الغرض'],
                                    ],
                                    'label' => [
                                        'text' => 'الغرض',
                                    ],
                                ]" />
                            </div><!-- property_status_id -->

                            <div class="col-md-4">
                                <x-form-group :properties="[
                                    'select' => [
                                        'name' => 'furnishing_status_id',
                                        'list' => $furnishingStatuses,
                                        'selected' => '',
                                        'options' => ['placeholder' => 'اختر'],
                                    ],
                                    'label' => [
                                        'text' => 'مستوي التشطيب',
                                    ],
                                ]" />
                            </div><!-- furnishing_status_id -->

                        </div>
                    </x-panel-with-heading>

                    <x-panel-with-heading class="hide -body" title="المميزات & الراحة">
                        <div class="row">

                            <div class="col-md-6">
                                <x-form-group :properties="[
                                    'select' => [
                                        'name' => 'feature_id[]',
                                        'list' => $features,
                                        'selected' => 'empty',
                                        'options' => [
                                            'class' => 'select2-multiple',
                                            'multiple',
                                        ],
                                    ],
                                    'label' => [
                                        'text' => 'المميزات',
                                    ],
                                ]" />
                            </div><!-- feature_id -->

                            <div class="col-md-6">
                                <x-form-group :properties="[
                                    'select' => [
                                        'name' => 'amenity_id[]',
                                        'list' => $amenities,
                                        'selected' => 'empty',
                                        'options' => [
                                            'class' => 'select2-multiple',
                                            'multiple',
                                        ],
                                    ],
                                    'label' => [
                                        'text' => 'وسائل الراحة',
                                    ],
                                ]" />
                            </div><!-- amenity_id -->

                        </div>
                    </x-panel-with-heading>

                    <x-panel-with-heading class="hide -body" title="تضمين خريطة">
                        <x-form-group class="mb-1 pt-2" :properties="[
                            'textarea' => [
                                'name' => 'google_map_iframe',
                                'options' => [
                                    'rows' => '6',
                                    'class' => 'ltr',
                                ],
                            ],
                        ]" />
                        <small class=" text-muted">
                            قم بالذهاب إلي <a target="__blank" href="https://www.google.com/maps">خرائط جوجل</a>
                            وابحث عن المكان بعد ذلك
                            قم بمشاركة الخريطة
                            وانسخ المحتوي بداخل قسم
                            تضمين خريطة
                        </small>
                    </x-panel-with-heading>


                </div><!-- col-10 -->

                <div id="publish-buttons-bar">
                    <button class="btn btn-main px-4" type="submit">اضافة الإعلان</button>
                </div><!-- Buttons -->


            </div>
        </form><!-- end form -->
    </main>






@endsection
<x-dashboard.js :links="[
    [
        'link' => 'properties/index.js',
        'type' => 'module',
    ],
]" />
