<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInterestsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('interests', function (Blueprint $table) {
            $table->id();
            $table->string('name', 150);                     // اسم العميل
            $table->string('email', 150)->nullable();        // البريد الإلكتروني
            $table->string('phone', 50)->nullable();         // رقم الهاتف
            $table->text('notes')->nullable();               // ملاحظات إضافية (اختياري)
            $table->enum('is_read', ['1', '0'])->default('0'); // رقم الهاتف
            $table->timestamps();                            // created_at & updated_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('interests');
    }
}
