<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('property_units', function (Blueprint $table) {
            $table->id();
            $table->string('name', 60);
            $table->string('area');
            $table->string('bedrooms');
            $table->string('bathrooms');
            $table->unsignedInteger('price')->index();
            $table->string('image')->nullable();
            // Relation
            $table->foreignId('property_id')->constrained()->cascadeOnDelete();
            //
            $table->foreignId('admin_id')->nullable()->constrained('admins')->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('property_units');
    }
};
