<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('properties', function (Blueprint $table) {
            $table->id();

            // بيانات أساسية
            $table->string('title', 191);
            // UUID للروابط
            $table->uuid('uuid')->unique()->index();

            $table->text('description')->nullable();

            $table->string('main_image', 100)->nullable();

            // تفاصيل السعر و المساحة
            $table->unsignedInteger('price')->index();
            $table->float('area')->nullable()->index();

            // تفاصيل العقار
            $table->integer('bedrooms')->nullable();
            $table->integer('bathrooms')->nullable();

            $table->string('floor',50)->nullable()->comment('الدور');
            $table->string('front', 45)->nullable()->comment('الواجهة');

            $table->foreignId('admin_id')->nullable()->constrained('admins')->nullOnDelete();

            // الموقع
            $table->text('google_map_iframe')->nullable();
            $table->foreignId('city_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('neighborhood_id')->nullable()->constrained()->nullOnDelete();

            // المراجع
            $table->foreignId('property_type_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('property_status_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('furnishing_status_id')->nullable()->constrained()->nullOnDelete();

            // بيانات أساسية
            $table->string('title_normalized', 191);
            $table->text('description_normalized')->nullable();

            $table->unsignedBigInteger('views_count')->default(0)->index();

            $table->timestamps();
        });

        // fulltext index للبحث
        DB::statement('ALTER TABLE properties ADD FULLTEXT(title_normalized, description_normalized)');

    }

    public function down(): void
    {
        Schema::dropIfExists('properties');
    }
};
