<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('furnishing_statuses', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // Furnished, Semi-Furnished, Unfurnished
            $table->foreignId('admin_id')->nullable()->constrained('admins')->nullOnDelete();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('furnishing_statuses');
    }
};
