<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {

            // Main
            $table->id();
            $table->string('logo', 100)->nullable();
            $table->string('website_icon', 100)->nullable();
            $table->string('website_name', 100)->nullable();
            $table->text('website_desc')->nullable();

            //contact
            $table->string('email', 120)->nullable();
            $table->string('phone', 60)->nullable();
            // Social

            $table->string('facebook')->nullable();
            $table->string('snapchat')->nullable();
            $table->string('twitter')->nullable();
            $table->string('instagram')->nullable();
            $table->string('youtube')->nullable();
            $table->string('telegram')->nullable();
            $table->string('whatsapp')->nullable();
            $table->string('tiktok')->nullable();

            // $table->text('website_location')->nullable();
            // $table->string('logo_footer', 150)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
};
