<?php
namespace App\Http\Controllers\Property;

use App\Helpers\Response;
use App\Http\Controllers\Controller;
use App\Models\FurnishingStatus;
use Illuminate\Http\Request;

class FurnishingController extends Controller
{

    public function __construct()
    {
        $this->middleware(['permission:property_furnishing_view'], ['only' => ['index']]);
        $this->middleware(['permission:property_furnishing_create'], ['only' => ['store']]);
        $this->middleware(['permission:property_furnishing_edit'], ['only' => ['update']]);
        $this->middleware(['permission:property_furnishing_delete'], ['only' => ['destroy']]);
    }

    public function routes($route)
    {
        $routes = [
            'index'   => route('property.furnishing.index'),
            'update'  => route('property.furnishing.update'),
            'store'   => route('property.furnishing.store'),
            'destroy' => route('property.furnishing.destroy'),
        ];

        return $routes[$route];
    }

    public function model()
    {
        return (new FurnishingStatus);
    }

    // Show All Rows
    public function index()
    {

        $rows = $this->model()::with('admin')->orderByDesc('id')->get();

        $destroyRoute = $this->routes('destroy');

        // Check IF Have Edit
        $id = intval(request('edit'));

        if ($id != 0) {
            $editRow = $this->model()::where('id', $id)->first()->toArray();
            // Form Update Options
            $formOption = [
                'panelTitle'   => 'تحديث بيانات م التشطيب',
                'submitButton' => 'تحديث',
                'formAction'   => $this->routes('update'),
            ];

            if ($editRow == null) {
                return redirect($this->routes('index'))->with('warning', 'البيانات المطلوبة غير متاحة في النظام');
            }
        } else {

            // Form Create Options
            $editRow    = [];
            $formOption = [
                'panelTitle'   => 'اضافة م التشطيب جديد',
                'submitButton' => 'اضافة',
                'formAction'   => $this->routes('store'),
            ];
        }

        return view('dashboard.system-data.furnishing', compact('rows', 'editRow', 'formOption', 'destroyRoute'));
    }

    // Insert New Row
    public function store(Request $request)
    {

        //
        $data = $request->validate([
            'name' => 'required|max:60|min:2|unique:' . $this->model()->table . ',name',
        ]);

        //
        $data['admin_id'] = adminId();

        // Insert
        $this->model()->create($data);

        return Response::success('تم اضافة البيانات بنجاح...', ['style' => 'toastr', 'reset' => true, 'reload' => true, 'time_out' => 1]);
    }

    // Update Row
    public function update(Request $request)
    {

        $row = $this->model()::where('id', $request->id)->first();

        // Check If Not Exists in db
        if ($row == null) {
            return Response::error('البيانات المطلوبة غير متوفرة في النظام', ['style' => 'toastr']);
        }

        // Validate Data
        $data = $request->validate([
            'name' => 'required|max:150|min:2|unique:' . $this->model()->table . ',name,' . $row->id,
        ]);

        // Insert
        $row->update($data);

        // Return Message
        return Response::success('تم تحديث البيانات بنجاح...', ['style' => 'toastr', 'redirect' => $this->routes('index'), 'reload' => true, 'time_out' => 1]);
    }

    // Delete Row
    public function destroy()
    {
        // Get Row And Check IF IN Database
        $row = $this->model()::find(request('id'));

        // Check If Not Exist The Row IN Database
        if (empty($row)) {
            // Message
            return Response::error('هذه العملية غير مصرح بها، وقد لا تكون البيانات المطلوبة متاحة في النظام', ['style' => 'toastr']);
        } else {
            // Delete From DB
            $row->delete();
            //Message
            return Response::success('تم حذف البيانات بنجاح', ['style' => 'toastr']);
        }
    }

} // End Class
