<?php
namespace App\Http\Controllers\Properties;

use App\Helpers\File;
use App\Helpers\Response;
use App\Http\Controllers\Controller;
use App\Models\PropertyAttachment;
use Illuminate\Http\Request;

class PropertyAattachmentsController extends Controller
{

    // Upload Options For Image
    const PATH      = 'properties/attachments';
    const LARGE     = '1232*753*75';
    const SMALL     = '161*95*75';
    const EXTENSION = 'webp';
    const HASH_NAME = false;

    const MAX_UPLOAD_SIZE  = 52428800; // 50MP
    const MAX_UPLOAD_FILES = 20;
    const ALLOWED_EXT      = "jpeg,jpg,png,webp,bmp,tiff,svg";

    public function __construct()
    {
        $this->middleware(['permission:properties_create'], ['only' => ['store', 'upload_attachments', 'destroy']]);
    }

    // public function upload_attachments($id, Request $request, Property $propertyModel)
    // {

    //     $row = $propertyModel->where('id', $id)->firstOrFail();

    //     $page_title = 'الإعلانات العقارية';

    //     //
    //     $maxSize  = ceil(self::MAX_UPLOAD_SIZE / 1024 / 1024);
    //     $maxFiles = self::MAX_UPLOAD_FILES;

    //     return view('dashboard.properties.upload', compact('row', 'page_title', 'maxSize', 'maxFiles'));

    // }

    // Store
    public function store(Request $request, PropertiesController $propertiesController)
    {

        $request->validate([
            'upload' => 'required',
        ]);

        $files = $request->upload;
        // Size For Set All Here
        $size = 0;

        foreach ($files as $file) {
            $size += $file->getSize();
        }

        if ($size > self::MAX_UPLOAD_SIZE) {
            return Response::error('Max Upload Size Is Big');
        } else {
            if (count($files) > self::MAX_UPLOAD_FILES) {
                return Response::error('Big File Upload ( ' . count($files) . ' ) File');
            } else {

                $original = $request->original;

                $uploadOptions = [
                    // 'large'     => self::LARGE,
                    'path'      => self::PATH,
                    'medium'    => $propertiesController::MEDIUM,
                    'small'     => $propertiesController::SMALL,
                    'extension' => self::EXTENSION,
                ];

                $imageData = File::multiUpload('upload', $uploadOptions);

                foreach ($imageData as $row) {
                    PropertyAttachment::create([
                        'attachment_name' => $row['file_name'],
                        'extension'       => $row['extension'],
                        'type'            => $row['mime_type'],
                        'property_id'     => $request->id,
                    ]);
                }

                return Response::success('Uploaded Successfully');
            }
        }
    }

    public function destroy(Request $request)
    {
        $id = $request->id;
        // Get Row And Check IF IN Database
        $row = PropertyAttachment::find($id);
        // Check If Not Exist The Row IN Database
        if (! empty($row)) {

            // Delete Admin Image Profile
            File::delete(self::PATH, $row->attachment_name);

            // Delete From DB
            $row->delete();

            return Response::success('تم حذف الصورة بنجاح', ['style' => 'toastr']);

        }
    }
}
