<?php
// Classes
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Properties\PropertiesController;

/**
 * Global
 */
function bootstrapColors()
{
    return ['danger', 'primary', 'success', 'secondary', 'warning', 'info', 'light', 'dark'];
}

/**
 * Get Auth Info
 * $guard = Auth Guard Name
 * $get   = Get Auth Value
 */
function getAuth($guard, $get)
{
    if (Auth::guard($guard)->check()) {
        return auth($guard)->user()->$get;
    } else {
        return null;
    }
}

/**
 * Print Message
 * v1
 */
function alert($message, $color = 'info')
{
    /**
     * Check IF The Color Exist In Pallette Or No
     */
    if (in_array($color, bootstrapColors())) {
        // IF Color Ture Print Message
        echo "<div class='text-center alert alert-" . $color . "'>" . $message . "</div>";
    } else {
        /**
         * Else Print Error Message And All Color For Choose
         */
        echo '<div class="container"> <div class="row">';
        echo "<div class='col-12 mb-3'><h6>This Color ( <b class='text-danger'>" . $color . "</b> ) Does Not Exist Choose Your Color From Palettes</h6></div>";
        foreach (bootstrapColors() as $co) {
            echo '<div class="col"><div class="alert alert-' . $co . ' p-2 rounded">' . $co . '</div></div>';
        }
        echo '</div></div>';
    }
}

/**
 * Parse String Time With Carbon Class
 */
function parseTime($time = null)
{
    if ($time == null) {
        $time = date('Y-m-d h:i:s');
    }
    return Carbon::parse($time)->diffForHumans();
}

/**
 * Function For Set Actives Class To Blade Pages
 * $url = Page Uri
 * $setClassName = If Need Set Other Class Name
 */
function activeLink($url, $setClassName = 'active')
{
    if (request()->path() == $url) {
        return $setClassName;
    } else {
        return false;
    }
}

/**
 * This Function Use For One Row From Database
 * - Check IF Row Exist not empty
 * - If Not Empty Return $column value
 */
function getVal($dbRow, string $column)
{
    return empty($dbRow)  ?null : $dbRow[$column];
}

if (! function_exists('currency_icon')) {
    function currency_icon()
    {
        return file_get_contents(asset('dashboard/images/sar.svg'));

    }
}

function fake_id()
{
    return 201924;
}

/**
 * This Function Format url slug and add the id
 * @param string $route name
 * @param string $name for the product or anything you need
 * @param int $id
 * example: slugUrl('product','how to make website',50);
 * return product/how-to-make-website-50;
 */
function make_slug(string $name, int $id, bool $accept_arabic = false)
{
    // تحويل الاسم إلى lowercase (بالنسبة للعربي مش هيفرق)
    $slug = strtolower($name);

    if ($accept_arabic) {
        // يسمح بالحروف الإنجليزية + العربية + الأرقام + المسافة
        $slug = preg_replace('/[^\p{Arabic}a-z0-9\s]/u', '', $slug);
    } else {
        // يسمح بالإنجليزي والأرقام فقط
        $slug = preg_replace('/[^a-z0-9\s]/', '', $slug);
    }

    // استبدال المسافات بـ "-"
    $slug = preg_replace('/\s+/', '-', $slug);

    // إزالة أي "-" في البداية أو النهاية
    return $slug = trim($slug, '-') . '-' . $id + fake_id();

}

/**
 * This Function Get Id From Slug
 * @param string $slug
 * example: product/how-to-make-website-50
 * return 50; this is the id
 */
function getIdFromSlug($slug)
{
    return Str::of($slug)->explode('-')->last();
}



// Get Article Image IF Exists
function propertyImage($imgName, $size = 'small')
{
    $default_image = asset('assets/images/default/properties.png');
    if ($imgName) {

        // تأكد من أن الحجم صالح
        $size = in_array($size, ['large', 'medium', 'small']) ? $size : 'small';

        // المسار الأساسي
        $controller = PropertiesController::class;
        $path       = $controller::PATH . '/' . $imgName;

        // إعدادات المسارات الخاصة بالأحجام
        $sizePaths = [
            'large'  => largePath($path),
            'medium' => mediumPath($path),
            'small'  => smallPath($path),
        ];

        // إعدادات الروابط الخاصة بالأحجام
        $sizeAssets = [
            'large'  => largeAsset($path),
            'medium' => mediumAsset($path),
            'small'  => smallAsset($path),
        ];

        // التحقق من وجود الصورة، وإرجاع المسار المناسب، أو الصورة الافتراضية
        return file_exists($sizePaths[$size]) ? $sizeAssets[$size] : $default_image;

    } else {
        return $default_image;
    }
}



function normalizeArabic($text, $removeStopwords = true)
{
    if (! $text) {
        return $text;
    }

    // 1- توحيد الحروف (مع تحويل التاء المربوطة افتراضياً)
    $map = [
        'أ' => 'ا', 'إ' => 'ا', 'آ' => 'ا', 'ٱ' => 'ا',
        'ى' => 'ي', 'ئ' => 'ي', 'ؤ' => 'و',
        'ة' => 'ه',
        'ٮ' => 'ي', 'ے' => 'ي', 'ؽ' => 'ي', 'ؾ' => 'ي', 'ؿ' => 'ي',
    ];

    $text = strtr($text, $map);

    // 2- إزالة التشكيل + الكشيدة + العلامات المركبة
    $text = preg_replace('/[ـ\p{Mn}]/u', '', $text);

    // 3- إزالة أي رموز غير عربية/إنجليزية/أرقام/مسافات
    $text = preg_replace('/[^ء-يa-zA-Z0-9\s]/u', ' ', $text);

    // 4- lowercase للتوحيد
    $text = mb_strtolower($text, 'UTF-8');

    // 5- تنظيف المسافات الزائدة
    $text = preg_replace('/\s+/', ' ', $text);
    $text = trim($text);

    // 6- إزالة الكلمات الشائعة (Stopwords)
    if ($removeStopwords) {
        $stopwords = array_flip(config('stopwords', []));
        $words     = explode(' ', $text);

        $words = array_filter($words, function ($word) use ($stopwords) {
            $baseWord = $word;

            // شيل البادئات بس لو الكلمة أكتر من حرفين
            if (mb_strlen($word, 'UTF-8') > 2) {
                $baseWord = preg_replace('/^(و|ف|ب|ك|ل)/u', '', $baseWord);
            }

            $baseWord = preg_replace('/^ال/u', '', $baseWord);

            return $baseWord !== '' && ! isset($stopwords[$baseWord]);
        });

        $text = implode(' ', $words);
    }

    return $text;
}
