@extends('dashboard.layouts.master')
@section('title', 'عرض المناطق')

<x-dashboard.css :links="[
    [
        'link' => 'services/services.css',
    ],
]" />

@section('content')

    <x-dashboard.links-bar :links="[
        [
            'name' => 'عرض المناطق',
        ],
    ]" :buttons="[
        [
            'name' => 'عرض المدن',
            'class' => 'btn-main',
            'can' => 'city_view',
            'link' => adminUrl('cities'),
        ],
    ]" /><!-- links bar -->

    <section id="">
        <div class="row">

            @can('neighborhood_create')
                <div class="col-lg-3 col-md-4">
                    <x-panel-with-heading title="{{ $formOption['panelTitle'] }}">
                        <form class=" form" action="{{ $formOption['formAction'] }}" method="POST" enctype="multipart/form-data">
                            @csrf

                            @isset($editRow['id'])
                                <input type="hidden" name="id" value="{{ $editRow['id'] }}">
                                @method('PATCH')
                            @endisset

                            <x-form-group :properties="[
                                'input' => [
                                    'name' => 'name',
                                    'type' => 'text',
                                    'value' => isset($editRow['name']) ? $editRow['name'] : '',
                                    'options' => ['required'],
                                ],
                                'label' => [
                                    'text' => 'اسم المنطقة',
                                    'options' => ['class' => 'required'],
                                ],
                            ]" /><!-- name -->

                            <x-form-group :properties="[
                                'select' => [
                                    'name' => 'city_id',
                                    'list' => $cities,
                                    'selected' => isset($editRow['city_id']) ? $editRow['city_id'] : '',
                                    'options' => ['required', 'class' => 'font-17', 'placeholder' => 'اختر'],
                                ],
                                'label' => [
                                    'text' => 'المنطقة تابعة لمدينة ؟',
                                    'options' => ['class' => 'required'],
                                ],
                            ]" /><!-- city -->

                            <button type="submit" class="btn btn-main btn-block ">{{ $formOption['submitButton'] }}</button>
                        </form>
                    </x-panel-with-heading>
                </div>
            @endcan

            <div class="@can('neighborhood_create'){{ 'col-lg-9 col-md-8' }} @else {{ 'col-12' }} @endcan">

                <x-panel-with-heading title="قسم البحث">
                    <form action="" method="get">
                        <div class="row">

                            <div class="col-lg-4">
                                <x-form-group :properties="[
                                    'input' => [
                                        'name' => 'name',
                                        'type' => 'text',
                                        'value' => request('name'),
                                        'options' => ['placeholder' => 'ابحث باسم المنطقة'],
                                    ],
                                ]" /><!-- filter name -->
                            </div>

                            <div class="col-lg-5">
                                <x-form-group :properties="[
                                    'select' => [
                                        'name' => 'city',
                                        'list' => $cities,
                                        'selected' => request('city'),
                                        'options' => ['placeholder' => 'اختر المدينة'],
                                    ],
                                ]" /><!-- filter city -->
                            </div>

                            @if (request('city') != null || request('name') != null)
                                <div class="col-lg-3">
                                    <div class="row">
                                        <div class="col-6">
                                            <button type="submit" class="btn btn-soft-main btn-block">بحث</button>
                                        </div><!-- submit search -->
                                        <div class="col-6 pr-0">
                                            <a href="{{ adminUrl('neighborhoods') }}" class="btn btn-danger btn-block">إلغاء
                                                البحث</a>
                                        </div><!-- clear search -->
                                    </div>
                                </div>
                            @else
                                <div class="col-lg-3">
                                    <button type="submit" class="btn btn-soft-main btn-block">بحث</button>
                                </div>
                            @endif

                        </div><!-- end row -->
                    </form>
                </x-panel-with-heading>

                <div class="box table-responsive">
                    <table class="table table-modern table-modern-sm table-inverse">
                        <thead class="thead-inverse">
                            <tr>
                                @canany(['neighborhood_edit', 'neighborhood_delete'])
                                    <th>التحكم</th>
                                @endcanany
                                <th>الاسم</th>
                                <th>تابعة إلي مدينة</th>
                                <th>تاريخ الإضافة</th>
                                <th>اضيف بواسطة</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($rows as $row)
                                <tr class="parents">
                                    @canany(['neighborhood_edit', 'neighborhood_delete'])
                                        <td>
                                            @can('neighborhood_edit')
                                                <a class="btn btn-sm btn-soft-primary" href="?edit={{ $row->id }}">
                                                    <i class="fa fa-edit"></i>
                                                </a>
                                                <span class="px-1">-</span>
                                            @endcan

                                            @can('neighborhood_delete')
                                                <form class="ajax-delete d-inline-block"
                                                    action="{{ route('neighborhood.destroy') }}" method="POST">
                                                    @method('DELETE')
                                                    @csrf
                                                    <input type="hidden" class="id" name="id" value="{{ $row->id }}">
                                                    <button type="submit" data-delete="هل انت متأكد من حذف : {{ $row->name }}"
                                                        class="btn-delete-attech btn-sm btn btn-soft-danger">
                                                        <i class="fa fa-trash-alt"></i>
                                                    </button>
                                                </form>
                                            @endcan
                                        </td>
                                    @endcanany

                                    <td>{{ $row->name }}</td>
                                    <td>{{ $row->city->name }}</td>
                                    <td>{{ $row->created_at->format('Y-m-d') }}</td>
                                    <td>{!! $row->by != null ? $row->by->full_name : "<small class='text-muted'>لا يوجد</small>" !!}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div><!-- end box table -->

                <div class="mt-4 mb-5 pb-4">
                    <x-paginate :data="$rows" />
                </div>

            </div>

        </div><!-- row -->
    </section><!-- section -->

@endsection
