@extends('dashboard.layouts.master')
@section('title', 'عرض المدن')

<x-dashboard.css :links="[
    [
        'link' => 'services/services.css',
    ],
]" />


@section('content')


    <x-dashboard.links-bar :links="[
        [
            'name' => 'عرض المدن',
        ],
    ]" :buttons="[
        [
            'name' => '<i class=\'fa-solid fa-map-location-dot\'></i> عرض المناطق',
            'class' => 'btn-main',
            'can' => 'neighborhood_view',
            'link' => adminUrl('neighborhoods'),
        ],
    ]" /><!-- links bar -->


    <section id="">
        <div class="row">

            @can('city_create')
                <div class="col-lg-3 col-md-4">
                    <x-panel-with-heading title="{{ $formOption['panelTitle'] }}">
                        <form class=" form" action="{{ $formOption['formAction'] }}" method="POST" enctype="multipart/form-data">
                            @csrf

                            @isset($editRow['id'])
                                <input type="hidden" name="id" value="{{ $editRow['id'] }}">
                                @method('PATCH')
                            @endisset
                            <x-form-group :properties="[
                                'input' => [
                                    'name' => 'name',
                                    'type' => 'text',
                                    'value' => isset($editRow['name']) ? $editRow['name'] : '',
                                    'options' => ['required'],
                                ],
                                'label' => [
                                    'text' => 'اسم المدينة',
                                    'options' => [
                                        'class' => 'required',
                                    ],
                                ],
                            ]" /><!-- title -->

                            <button type="submit" class="btn btn-main btn-block ">{{ $formOption['submitButton'] }}</button>
                        </form>
                    </x-panel-with-heading>
                </div>
            @endcan

            <div class="@can('city_create'){{ 'col-lg-9 col-md-8' }} @else {{ 'col-12' }} @endcan">
                <div class="box px-0 pt-2 table-responsive">
                    <table class="table table-modern table-modern-sm table-inverse">
                        <thead class="thead-inverse">
                            <tr>
                                @canany(['city_edit', 'city_delete'])
                                    <th>التحكم</th>
                                @endcanany
                                <th>الاسم</th>
                                <th class="tip" title="عدد المناطق ذات الصلة بتلك المدينة">المناطق</th>
                                <th>تاريخ الإضافة</th>
                                <th>اضيف بواسطة</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($rows as $row)
                                <tr class="parents">
                                    @canany(['city_edit', 'city_delete'])
                                        <td>
                                            @can('city_edit')
                                                <a class="btn btn-sm btn-soft-primary" href="?edit={{ $row->id }}"><i
                                                        class=" fa fa-edit"></i>
                                                </a>
                                                <span class="text-secondary">|</span>
                                            @endcan

                                            @can('city_delete')
                                                <form class="ajax-delete d-inline-block" action="{{ route('city.destroy') }}"
                                                    method="POST">
                                                    @method('DELETE')
                                                    @csrf
                                                    <input type="hidden" class="id" name="id" value="{{ $row->id }}">
                                                    <button type="submit" data-delete="هل انت متأكد من حذف : {{ $row->name }}"
                                                        class="btn-delete-attech  btn-sm btn btn-soft-danger"><i
                                                            class=" fa fa-trash-alt"></i>
                                                    </button>
                                                </form>
                                            @endcan
                                        </td><!-- actions -->
                                    @endcanany

                                    <td>{{ $row->name }}</td>
                                    <td>
                                        <a href="{{ route('neighborhood.index') }}?city={{ $row->id }}">(
                                            {{ count($row->neighborhoods) }} ) منطقة</a>
                                    </td>
                                    <td>{{ parseTime($row->created_at) }}</td>
                                    <td>{!! $row->by != null ? $row->by->full_name : "<small class='text-muted'>لا يوجد</small>" !!}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

        </div><!-- row -->
    </section><!-- section -->




@endsection
