<?php
namespace Database\Seeders;

use App\Models\Amenity;
use App\Models\Feature;
use App\Models\FurnishingStatus;
use App\Models\PropertyStatus;
use App\Models\PropertyType;
use Illuminate\Database\Seeder;

class InitialDataSeeder extends Seeder
{
    public function run()
    {
        
        // أنواع العقارات
        PropertyType::insert([
            ['name' => 'شقة'],
            ['name' => 'فيلا'],
            ['name' => 'منزل مستقل'],
            ['name' => 'محل تجاري'],
            ['name' => 'أرض'],
            ['name' => 'مكتب'],
            ['name' => 'استوديو'],
            ['name' => 'دوبلكس'],
            ['name' => 'شقة فندقية'],
        ]);

        // حالات العقار
        PropertyStatus::insert([
            ['name' => 'للبيع'],
            ['name' => 'للإيجار'],
            ['name' => 'تم البيع'],
            ['name' => 'مستأجر'],
            ['name' => 'قيد الإنشاء'],
            ['name' => 'غير متاح'],
        ]);

        // حالات التأثيث
        FurnishingStatus::insert([
            ['name' => 'مفروش كامل'],
            ['name' => 'مفروش جزئي'],
            ['name' => 'غير مفروش'],
            ['name' => 'تأثيث فاخر'],
            ['name' => 'تأثيث عادي'],
        ]);

        // المميزات الشائعة
        Feature::insert([
            ['name' => 'مسبح'],
            ['name' => 'موقف سيارات خاص'],
            ['name' => 'حديقة'],
            ['name' => 'مصعد'],
            ['name' => 'نظام أمني'],
            ['name' => 'غرفة خادمة'],
            ['name' => 'غرفة غسيل'],
            ['name' => 'تكييف مركزي'],
            ['name' => 'تشطيب سوبر ديلوكس'],
        ]);

        // المرافق القريبة
        Amenity::insert([
            ['name' => 'مدرسة'],
            ['name' => 'مستشفى'],
            ['name' => 'سوبر ماركت'],
            ['name' => 'مسجد'],
            ['name' => 'مواصلات عامة'],
            ['name' => 'متنزه و حديقة عامة'],
            ['name' => 'مركز رياضي'],
        ]);
    }

}
