<?php
namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PropertieRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            // Main Data
            'title'                => 'required|string|max:191',
            'price'                => 'required|integer|min:0',
            'area'                 => 'required|numeric|min:0',
            'main_image'           => 'nullable|image|max:4096',
            'description'          => 'nullable|string|max:6000',
            // Details Data
            'city_id'              => 'required|exists:cities,id',
            'neighborhood_id'      => 'required|exists:neighborhoods,id',
            'property_type_id'     => 'required|exists:property_types,id',
            'bathrooms'            => 'nullable|integer|min:0',
            'bedrooms'             => 'nullable|integer|min:0',
            'floor'                => 'nullable|string|max:50',
            'front'                => 'nullable|string|max:50',
            'property_status_id'   => 'nullable|exists:property_statuses,id',
            'furnishing_status_id' => 'nullable|exists:furnishing_statuses,id',
            'google_map_iframe'    => 'nullable|max:5000',
            // Features & Amenity
            'feature_id'           => 'nullable|array',
            'feature_id.*'         => 'integer|exists:features,id',
            'amenity_id'           => 'nullable|array',
            'amenity_id.*'         => 'integer|exists:amenities,id',
        ];
    }
}
