<?php
    $removeFooter = isset($removeFooter) ? $removeFooter : false;
?>
<?php if($removeFooter != true): ?>
    <footer>

        <div class="top">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-6 footer-section">
                        <h5>
                            <img src="<?php echo e(largeAsset('settings/' . $settings->logo_footer)); ?>" alt="">
                        </h5>
                        <p> <?php echo e(Str::limit($settings->website_desc, 110)); ?></p>
                        <ul class="list-unstyled social-media-icons">
                            <?php $__currentLoopData = mainViewSocialMedia(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $valName = $val['name_en'];
                                ?>
                                <?php if(!empty($settings->$valName)): ?>
                                    <li>
                                        <a class="icon" href="<?php echo e($settings->$valName); ?>"
                                            target="_blank"><?php echo $val['icon']; ?></a>
                                    </li><!--  -->
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div class="col-lg-2 col-md-6 footer-section mt-4">
                        <h5>خريطة الموقع</h5>
                        <ul class="list-unstyled">
                            <li class="mb-3"><a href="#">الرئيسية</a></li>
                            <li class="mb-3"><a href="<?php echo e(url('real-estate-developers')); ?>">المطورين العقاريين</a></li>
                            <li class="mb-3"><a href="<?php echo e(url('products')); ?>">العقارات</a></li>
                            <li class="mb-3"><a href="<?php echo e(url('request-your-property')); ?>">اطلب عقارك</a></li>
                            <li class="mb-3"><a href="<?php echo e(url('contact')); ?>">اتصل بنا</a></li>
                            
                            <li><a href="<?php echo e(url('privacy-policy')); ?>"><?php echo e(mainTrans('footer.privacy policy')); ?></a></li>
                        </ul>
                    </div>
                    <div class="col-lg-2 col-md-6 footer-section mt-4">
                        <h5>اتصل بنا</h5>

                        <?php $__currentLoopData = explode('|', $settings->phone); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="tel:+<?php echo e($phone); ?>" class="mb-2 d-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="#000000"
                                    viewBox="0 0 256 256">
                                    <path
                                        d="M144.27,45.93a8,8,0,0,1,9.8-5.66,86.22,86.22,0,0,1,61.66,61.66,8,8,0,0,1-5.66,9.8A8.23,8.23,0,0,1,208,112a8,8,0,0,1-7.73-5.94,70.35,70.35,0,0,0-50.33-50.33A8,8,0,0,1,144.27,45.93Zm-2.33,41.8c13.79,3.68,22.65,12.54,26.33,26.33A8,8,0,0,0,176,120a8.23,8.23,0,0,0,2.07-.27,8,8,0,0,0,5.66-9.8c-5.12-19.16-18.5-32.54-37.66-37.66a8,8,0,1,0-4.13,15.46Zm81.94,95.35A56.26,56.26,0,0,1,168,232C88.6,232,24,167.4,24,88A56.26,56.26,0,0,1,72.92,32.12a16,16,0,0,1,16.62,9.52l21.12,47.15,0,.12A16,16,0,0,1,109.39,104c-.18.27-.37.52-.57.77L88,129.45c7.49,15.22,23.41,31,38.83,38.51l24.34-20.71a8.12,8.12,0,0,1,.75-.56,16,16,0,0,1,15.17-1.4l.13.06,47.11,21.11A16,16,0,0,1,223.88,183.08Zm-15.88-2s-.07,0-.11,0h0l-47-21.05-24.35,20.71a8.44,8.44,0,0,1-.74.56,16,16,0,0,1-15.75,1.14c-18.73-9.05-37.4-27.58-46.46-46.11a16,16,0,0,1,1-15.7,6.13,6.13,0,0,1,.57-.77L96,95.15l-21-47a.61.61,0,0,1,0-.12A40.2,40.2,0,0,0,40,88,128.14,128.14,0,0,0,168,216,40.21,40.21,0,0,0,208,181.07Z">
                                    </path>
                                </svg> <?php echo e($phone); ?>+
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php $__currentLoopData = explode('|', $settings->email); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="mailto:<?php echo e($email); ?>" class="mb-2 d-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="#000000"
                                    viewBox="0 0 256 256">
                                    <path
                                        d="M224,48H32a8,8,0,0,0-8,8V192a16,16,0,0,0,16,16H216a16,16,0,0,0,16-16V56A8,8,0,0,0,224,48ZM203.43,64,128,133.15,52.57,64ZM216,192H40V74.19l82.59,75.71a8,8,0,0,0,10.82,0L216,74.19V192Z">
                                    </path>
                                </svg>
                                <?php echo e($email); ?>

                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <div class="col-lg-5 col-md-6 footer-section mt-4">
                        <h5>تابعنا على الخريطة</h5>
                        <div class="map-container">
                            <?php echo $settings->website_location; ?>

                        </div>
                    </div>
                </div>
            </div>

        </div>

        <!-- الشريط الأبيض -->


        <div class="text-center bg-white py-4">
            <p class="mb-0">جميع الحقوق محفوظة لشركة <?php echo e($settings->website_name); ?> <?php echo e(date('Y')); ?></p>
        </div>


    </footer>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\wjhatna\resources\views/main/layouts/master/footer.blade.php ENDPATH**/ ?>