<?php $__env->startSection('title', 'عقارات للبيع في جدة | شقق وفلل بأسعار مميزة'); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/pages/home/home-v2.css')); ?>?v=<?php echo time(); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


    <header id="home-header" class="video-container">
        <div id="carouselExampleFade" class="carousel slide carousel-fade" data-ride="carousel">
            <div class="carousel-inner">
                <?php $__currentLoopData = $headerSlider; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fileVal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($fileVal['type'] == 'video'): ?>
                        <div class="carousel-item <?php echo e($loop->index == 0 ? 'active' : ''); ?>">
                            <video autoplay loop muted class="d-block w-100">
                                <source src="<?php echo e(largeAsset('designs/' . $fileVal['file_name'])); ?>" type="video/mp4">
                            </video>
                        </div>
                    <?php else: ?>
                        <div class="carousel-item <?php echo e($loop->index == 0 ? 'active' : ''); ?>">
                            <img src="<?php echo e(largeAsset('designs/' . $fileVal['file_name'])); ?>" class="d-block w-100"
                                alt="...">
                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <div class="overlay"></div> <!-- Optional: Add overlay -->
        <div class="header-content">
            <div class=" w-100 h-100 d-flex justify-content-center align-items-center">
                <div class="container">
                    <?php
                        $animi = ['animation-up', 'animation-up', 'animation-right'];
                    ?>
                    <?php $__currentLoopData = $headerSliderTitleDesc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sliderTitleDesc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="content <?php echo e($loop->index == 0 ? 'active' : ''); ?> <?php echo e($animi[rand(0, 2)]); ?>">
                            <h1 class="title title-one"><?php echo e($sliderTitleDesc['title']); ?></h1>
                            <p class="element mb-4"><?php echo e($sliderTitleDesc['desc']); ?></p>
                            <a href="#about" class="btn btn-main px-4">المزيد</a>
                        </div><!-- title - 1 -->
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div><!-- container  -->
            </div><!-- flex -->
        </div><!-- header-content -->
    </header>

    <section id="search" class="py-5">
        <div class="container">
            <h2 class="section-title line-after mb-4 mt-4">بحث متقدم</h2>
            <form action="<?php echo e(url('products')); ?>" method="get">

                <div class="row">

                    <div class="col-md-3">
                        <?php if (isset($component)) { $__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a = $component; } ?>
<?php $component = App\View\Components\FormGroup::resolve(['properties' => [
                            'select' => [
                                'name' => 'region',
                                'list' => $regions,
                                'options' => [
                                    'data-live-search' => true,
                                    'class' => 'font-17 searchable-select',
                                    'placeholder' => 'اختر الحي',
                                ],
                            ],
                        ]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form-group'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\FormGroup::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a)): ?>
<?php $component = $__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a; ?>
<?php unset($__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a); ?>
<?php endif; ?>
                    </div>


                    <div class="col-md-3">
                        <?php if (isset($component)) { $__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a = $component; } ?>
<?php $component = App\View\Components\FormGroup::resolve(['properties' => [
                            'select' => [
                                'name' => 'rooms',
                                'list' => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
                                'selected' => '',
                                'options' => ['class' => 'font-17', 'placeholder' => 'عدد الغرف'],
                            ],
                        ]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form-group'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\FormGroup::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a)): ?>
<?php $component = $__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a; ?>
<?php unset($__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a); ?>
<?php endif; ?>
                    </div><!-- rooms -->

                    <div class="col-md-3">
                        <?php if (isset($component)) { $__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a = $component; } ?>
<?php $component = App\View\Components\FormGroup::resolve(['properties' => [
                            'select' => [
                                'name' => 'type',
                                'list' => $buildingTypes,
                                'text' => 'type',
                                'options' => [
                                    'class' => 'font-17',
                                    'placeholder' => '',
                                    'data-url-get-neighborhoods' => route('getNeighborhoods'),
                                ],
                            ],
                        ]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form-group'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\FormGroup::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a)): ?>
<?php $component = $__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a; ?>
<?php unset($__componentOriginal1c669f5858ba8e548f3c58b275327fb2f8e6401a); ?>
<?php endif; ?>
                    </div><!-- type -->




                    <div class="col-md-3">
                        <button type="submit" class="btn btn-main btn-block">بحث</button>
                    </div><!-- room_numbers -->

                </div>

            </form>
        </div>
    </section>

    <main class="owl-products">
        <div class="container">
            <div class="text-center">
                <h2 class="line-before-and-after section-title text-center mb-5">تعرف على عقاراتنا</h2>
            </div>

            <div dir="ltr" class=" owl-carousel owl-theme ">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="item">
                        <div class="product-box">

                            <div class="main-image">

                                <a href="<?php echo e(url('product/' . Str::slug($prod->name)) . '-' . $prod->id); ?>">
                                    <img class="" src="<?php echo e(mediumAsset('products/' . $prod->main_image)); ?>"
                                        alt="">
                                </a><!-- link -->

                                <?php if($prod->get_deal_type != null): ?>
                                    <span class="badge-deal-type"><?php echo e($prod->get_deal_type->type); ?></span>
                                <?php endif; ?>

                                <?php

                                    if ($prod->get_status->id == 1) {
                                        $badgeStatusColor = 'success';
                                    } elseif ($prod->get_status->id == 2) {
                                        $badgeStatusColor = 'danger';
                                    } elseif ($prod->get_status->id == 3) {
                                        $badgeStatusColor = 'blue';
                                    } else {
                                        $badgeStatusColor = 'dark';
                                    }

                                ?>

                                <?php if($prod->get_status != null): ?>
                                    <span
                                        class="badge-status <?php echo e($badgeStatusColor); ?>"><?php echo e($prod->get_status->status); ?></span>
                                <?php endif; ?>



                                <span class="price set-price"
                                    data-price="<?php echo e(number_format($prod->price, 0, '.', ',')); ?> ريال سعودي"></span>
                            </div>

                            <a href="<?php echo e(url('product/' . Str::slug($prod->name)) . '-' . $prod->id); ?>">

                                <div class="info">
                                    <h3><?php echo e($prod->name); ?></h3>

                                    <?php if($prod->get_developer != null): ?>
                                        <div class="dev">
                                            <img class="dev-icon" src="<?php echo e(asset('assets/images/products/dev.svg')); ?>"
                                                alt="">
                                            المطور : <?php echo e(Str::limit($prod->get_developer->name, 100)); ?>

                                        </div>
                                    <?php endif; ?>


                                    <img class=" d-inline-block" style="width:9px"
                                        src="<?php echo e(asset('assets/images/products/city.svg')); ?>" alt="">
                                    <?php if($prod->get_city != null): ?>
                                        <span class="mr-1 ml-3"><?php echo e($prod->get_city->name); ?></span>
                                    <?php endif; ?>


                                    <img class=" d-inline-block" style="width:18px"
                                        src="<?php echo e(asset('assets/images/products/region.svg')); ?>" alt="">
                                    <?php if($prod->get_region != null): ?>
                                        <span class="mr-1"><?php echo e($prod->get_region->name); ?></span>
                                    <?php endif; ?>

                                </div><!-- end info -->

                                <div class="details">
                                    <div class="row">

                                        <div class="col text-center">
                                            <div class="icon">
                                                <span class="count"><?php echo e($prod->room_numbers); ?></span>
                                                <img class=" d-inline-block" style="width:26px"
                                                    src="<?php echo e(asset('assets/images/products/room.svg')); ?>" alt="">
                                            </div>
                                            <span class="mr-1">غرفة نوم</span>
                                        </div><!-- end col -->

                                        <div class="col text-center middel-col">
                                            <div class="icon">
                                                <span class="count"><?php echo e($prod->bathrooms_numbers); ?></span>
                                                <img class=" d-inline-block" style="width:26px"
                                                    src="<?php echo e(asset('assets/images/products/bathroom.svg')); ?>"
                                                    alt="">
                                            </div>
                                            <span class="mr-1">حمام</span>
                                        </div><!-- end col -->

                                        <div class="col text-center">
                                            <div class="icon">
                                                <span class="count"><?php echo e($prod->area_in_metres); ?></span>
                                                <img class=" d-inline-block" style="width:26px"
                                                    src="<?php echo e(asset('assets/images/products/mtr.svg')); ?>" alt="">
                                            </div>
                                            <span class="mr-1">مساحة</span>
                                        </div><!-- end col -->

                                    </div><!-- row -->
                                </div><!-- end details -->

                            </a>
                        </div>
                    </div><!-- end -->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

        </div>
    </main>

    <section id="about" class="py-5">
        <div class="container">

            <div class="text-center">
                <h2 class="section-title text-center line-before-and-after mb-3">وجهتنا العقارية فى سطور</h2>
            </div>

            <div class="row justify-content-center">
                <div class="col-md-9">
                    <p class=" text-center"><?php echo e($website_desc->website_desc); ?></p>
                </div>
            </div>

        </div>
    </section>

    <section id="why-choose" class="py-5">
        <div class="container-fluid">
            <div class="row">

                <div class="col-xl-6 col-lg-5 col-md-12 px-0">
                    <img class="w-100 h-100" style="object-fit: cover"
                        src="<?php echo e(asset('assets/images/home/image 5.jpg')); ?>" alt="">
                </div><!-- end image -->

                <div class="col-xl-4 col-lg-7 col-md-12">
                    <h2 class="section-title mb-5 mt-4 line-after">لماذا تختارنا</h2>
                    <?php $__currentLoopData = $whyChooseUs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $choose): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="item">
                            <div class="row">
                                <div class="col-xl-3 col-sm-2 col-12 col-icon">
                                    <div class="ic on mb-2 text-xl-center ">
                                        <img style="width: 85px" src="<?php echo e(largeAsset('services/' . $choose->image)); ?>"
                                            alt="">
                                    </div>
                                </div>
                                <div class="col-xl-9 col-sm-10 col-12 ">
                                    <h6 class="font-20"><?php echo e($choose->title); ?></h6>
                                    <p style="max-width: 480px" class=" text-muted mb-0"><?php echo e($choose->desc); ?></p>
                                </div>
                            </div><!-- end row -->
                        </div><!-- end item -->
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div><!-- end boxs -->

            </div>
        </div>
    </section>

    <section id="services">
        <div class="container">

            <div class="text-center">
                <div class="text-center mb-5">
                    <h2 class="section-title text-center line-before-and-after">تعرف على خدماتنا</h2>
                </div>
            </div>

            <div dir="ltr" class=" owl-carousel owl-theme ">
                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="item">

                        <a href="<?php echo e(url('service/' . str_replace(' ', '-', $serv->title) . '-' . $serv->id)); ?>">

                            <div class="service-box">
                                <img src="<?php echo e(largeAsset('services/' . $serv->image)); ?>" alt="">
                                <h5 class=" text-dark my-3 font-weight-700"><?php echo e($serv->title); ?></h5>
                                <p class=" text-dark mb-0"><?php echo e($serv->desc); ?></p>

                                <div class="link-box">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                                        <path
                                            d="M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.2 288 416 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-306.7 0L214.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160z" />
                                    </svg>
                                    <div class="">

                                    </div>
                                </div>
                            </div>

                        </a>

                    </div><!-- end  -->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

        </div>
    </section>

    <section id="our-achievements">
        <div class="container">
            <div class="text-center">
                <h2 class="section-title text-center line-before-and-after mb-5">انجازاتنا</h2>
            </div>

            <div class=" owl-carousel owl-theme news-items">
                <?php $__currentLoopData = $achievements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $achiev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="item">

                        <img class="lazy" data-src="<?php echo e(largeAsset('achievements/' . $achiev->image)); ?>"
                            alt="">
                        <div class="item-content">
                            <h2 class="title">
                                <?php echo e($achiev->name); ?>

                            </h2>
                        </div>
                    </div><!-- end -->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

        </div>
    </section>

    <section id="partners">
        <div class="container">
            <div class="text-center">
                <h2 class="section-title text-center line-before-and-after mb-5">معتمد من</h2>
            </div>
            <div class=" owl-carousel owl-theme remove-owl-dots">
                <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="item">
                        <img src="<?php echo e(largeAsset('partners/' . $partner)); ?>" alt="">
                    </div><!-- end -->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>


<?php $__env->stopSection(); ?> <!-- End Content -->
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('assets/js/pages/home/home.js')); ?>?v=<?php echo time(); ?>"></script>

    <script>
        $('.searchable-select').selectpicker();

        $("#our-achievements .owl-carousel").owlCarousel({
            loop: true,
            autoplay: true,
            autoplayTimeout: 4000, // 5 seconds
            autoplaySpeed: 2000, // 1 second
            smartSpeed: 1000, // 1 second
            autoplayHoverPause: true,
            margin: 20,
            nav: false,
            responsive: {
                0: {
                    items: 1,
                },
                768: {
                    items: 2,
                },
                1000: {
                    items: 4,
                },
            },
        });

        $("#partners .owl-carousel").owlCarousel({
            loop: true,
            autoplay: true,
            autoplayTimeout: 2000, // 5 seconds
            autoplaySpeed: 1000, // 1 second
            smartSpeed: 1000, // 1 second
            autoplayHoverPause: true,
            margin: 20,
            nav: false,
            responsive: {
                0: {
                    items: 2,
                },
                600: {
                    items: 2,
                },
                1000: {
                    items: 6,
                },
            },
        });

        $("main .owl-carousel").owlCarousel({
            loop: true,
            autoplay: true,
            autoplayTimeout: 4000, // 5 seconds
            autoplaySpeed: 3000, // 1 second
            smartSpeed: 1000, // 1 second
            autoplayHoverPause: true,
            margin: 30,
            nav: true,
            responsive: {
                0: {
                    items: 1,
                },
                768: {
                    items: 2,
                },
                1000: {
                    items: 3,
                },
            },
        });

        $("#services .owl-carousel").owlCarousel({
            loop: false,
            autoplay: true,
            autoplayTimeout: 2000, // 5 seconds
            autoplaySpeed: 1000, // 1 second
            smartSpeed: 1000, // 1 second
            autoplayHoverPause: true,
            margin: 30,
            nav: true,
            responsive: {
                0: {
                    items: 1,
                },
                768: {
                    items: 2,
                },
                1000: {
                    items: 3,
                },
            },
        });

    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('main.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\wjhatna\resources\views/main/home.blade.php ENDPATH**/ ?>