@php
    $removeNavbar = true;
@endphp
@extends('main.layouts.master')
@section('title', env('APP_NAME'))
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/css/pages/marketing/index.css') }}">
    <link rel="stylesheet" href="{{ asset('dashboard/css/components/components.css') }}">
    <!-- global & plugins -->
    <link rel="stylesheet" href="{{ asset('dashboard/css/override/override.css') }}?v=<?php echo time(); ?>" />
    <!-- global -->
    <style>
        input::placeholder {
            text-align: right;
        }

        svg {
            width: 28px;
            height: 28px;
        }
    </style>
@endsection
@section('content')

    <!-- Hero Section with Form -->
    <section class="hero d-flex align-items-center text-center">
        <div class="container">
            <div class="row justify-content-center">

                <div class="col-md-10 col-lg-12">

                    <img src="{{ website_logo() }}" alt="logo" class="hero-logo mb-3">
                    <h1 style="font-size: clamp(1.125rem, 0.9489rem + 0.5634vw, 1.625rem);" class="hero-title">دليلك العقاري
                        – نبحث لك عن الشقة الأنسب</h1>
                    <p style="font-size: clamp(1rem, 0.868rem + 0.4225vw, 1.375rem);" class="hero-desc mb-4">
                        خدمتك الأولى للبحث عن السكن المناسب. سجّل بياناتك الآن، ودعنا نوفّر لك خيارات شقق تناسب احتياجاتك
                        وميزانيتك بسهولة وشفافية.
                    <p>


                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="card hero-form mt-0 shadow-lg">
                                <div class="card-body p-4 p-sm-5">
                                    <h4 class="mb-3 font-weight-600">سجّل اهتمامك الآن</h4>

                                    @if (session('success'))
                                        <div class="alert alert-success text-center">
                                            {{ session('success') }}
                                        </div>
                                    @endif

                                    <form method="POST" action="{{ route('interests.store') }}">
                                        @csrf

                                        <div class="row">
                                            
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <input type="text" name="name" value="{{ old('name') }}"
                                                        class="form-control @error('name') is-invalid @enderror"
                                                        placeholder="الاسم الكامل" required>
                                                    @error('name')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <input type="text" name="phone" value="{{ old('phone') }}"
                                                        style="direction:ltr;"
                                                        class="form-control text-left @error('phone') is-invalid @enderror"
                                                        placeholder="رقم الهاتف">
                                                    @error('phone')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <input type="email" name="email" value="{{ old('email') }}"
                                                        style="direction:ltr;"
                                                        class="form-control text-left @error('email') is-invalid @enderror"
                                                        placeholder="البريد الإلكتروني ( إختياري )">
                                                    @error('email')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                            </div>


                                        </div>


                                        <button type="submit" class="btn btn-main btn-block">إرسال</button>
                                    </form>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <div class="row justify-content-center mt-4">
                @foreach ($items as $item)
                    <div class="col-lg-3 col-md-5 col-6 mb-4">
                        <div class="card h-100 mt-0 hero-form shadow-lg">
                            <div class=" text-center py-4 px-3 px-md-0 ">
                                {!! $item['icon'] !!}
                                <h6 class="mt-2 mb-0 font-weight-bold">{{ $item['name'] }}</h6>
                                <p class="mb-0">{{ $item['desc'] }}</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <p class="hero-desc">انضم لعملائنا الآن، ودعنا نبحث لك عن شقتك المثالية بثقة.</p>

            <a class="btn btn-success px-4 py-2" href="{{ $settings->whatsapp }}">
                <svg xmlns="http://www.w3.org/2000/svg" fill="#ffffff" viewBox="0 0 640 640">
                    <path
                        d="M476.9 161.1C435 119.1 379.2 96 319.9 96C197.5 96 97.9 195.6 97.9 318C97.9 357.1 108.1 395.3 127.5 429L96 544L213.7 513.1C246.1 530.8 282.6 540.1 319.8 540.1L319.9 540.1C442.2 540.1 544 440.5 544 318.1C544 258.8 518.8 203.1 476.9 161.1zM319.9 502.7C286.7 502.7 254.2 493.8 225.9 477L219.2 473L149.4 491.3L168 423.2L163.6 416.2C145.1 386.8 135.4 352.9 135.4 318C135.4 216.3 218.2 133.5 320 133.5C369.3 133.5 415.6 152.7 450.4 187.6C485.2 222.5 506.6 268.8 506.5 318.1C506.5 419.9 421.6 502.7 319.9 502.7zM421.1 364.5C415.6 361.7 388.3 348.3 383.2 346.5C378.1 344.6 374.4 343.7 370.7 349.3C367 354.9 356.4 367.3 353.1 371.1C349.9 374.8 346.6 375.3 341.1 372.5C308.5 356.2 287.1 343.4 265.6 306.5C259.9 296.7 271.3 297.4 281.9 276.2C283.7 272.5 282.8 269.3 281.4 266.5C280 263.7 268.9 236.4 264.3 225.3C259.8 214.5 255.2 216 251.8 215.8C248.6 215.6 244.9 215.6 241.2 215.6C237.5 215.6 231.5 217 226.4 222.5C221.3 228.1 207 241.5 207 268.8C207 296.1 226.9 322.5 229.6 326.2C232.4 329.9 268.7 385.9 324.4 410C359.6 425.2 373.4 426.5 391 423.9C401.7 422.3 423.8 410.5 428.4 397.5C433 384.5 433 373.4 431.6 371.1C430.3 368.6 426.6 367.2 421.1 364.5z" />
                </svg>
                تواصل مباشر
            </a>

            <a href="" class="px-2 py-2 px-3 btn btn-light">
                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="#000000" viewBox="0 0 256 256">
                    <path
                        d="M144.27,45.93a8,8,0,0,1,9.8-5.66,86.22,86.22,0,0,1,61.66,61.66,8,8,0,0,1-5.66,9.8A8.23,8.23,0,0,1,208,112a8,8,0,0,1-7.73-5.94,70.35,70.35,0,0,0-50.33-50.33A8,8,0,0,1,144.27,45.93Zm-2.33,41.8c13.79,3.68,22.65,12.54,26.33,26.33A8,8,0,0,0,176,120a8.23,8.23,0,0,0,2.07-.27,8,8,0,0,0,5.66-9.8c-5.12-19.16-18.5-32.54-37.66-37.66a8,8,0,1,0-4.13,15.46Zm81.94,95.35A56.26,56.26,0,0,1,168,232C88.6,232,24,167.4,24,88A56.26,56.26,0,0,1,72.92,32.12a16,16,0,0,1,16.62,9.52l21.12,47.15,0,.12A16,16,0,0,1,109.39,104c-.18.27-.37.52-.57.77L88,129.45c7.49,15.22,23.41,31,38.83,38.51l24.34-20.71a8.12,8.12,0,0,1,.75-.56,16,16,0,0,1,15.17-1.4l.13.06,47.11,21.11A16,16,0,0,1,223.88,183.08Zm-15.88-2s-.07,0-.11,0h0l-47-21.05-24.35,20.71a8.44,8.44,0,0,1-.74.56,16,16,0,0,1-15.75,1.14c-18.73-9.05-37.4-27.58-46.46-46.11a16,16,0,0,1,1-15.7,6.13,6.13,0,0,1,.57-.77L96,95.15l-21-47a.61.61,0,0,1,0-.12A40.2,40.2,0,0,0,40,88,128.14,128.14,0,0,0,168,216,40.21,40.21,0,0,0,208,181.07Z">
                    </path>
                </svg>
                {{ $settings->phone }}
            </a>

        </div>
    </section>


@endsection
