@extends('dashboard.layouts.master')
@section('title', 'اضافة جديد')
<x-dashboard.css :links="[
    [
        'link' => 'properties/index.css',
    ],
]" />
@section('content')


    <x-dashboard.links-bar :links="[
        [
            'name' => $page_title,
            'link' => route('properties.index'),
        ],
        [
            'name' => Str::limit($row->title, 15),
        ],
    ]" /><!-- links bar  -->


    <main class="mb-5 pb-5">
        <section id="gallery">
            <div id="uploader">

                <div class="alert alert-info text-center" role="alert">
                    <strong>يمكنك رفع صور ضمن مشروع</strong>
                    <p class="mb-0 mt-2">" {{ $row->title }} "</p>
                </div>

                <form id="update-form" class="form-upload-attachments" action="{{ route('properties.attachments.upload') }}"
                    method="POST" enctype="multipart/form-data">
                    <div class="pb-5 box text-center">

                        <input type="hidden" name="id" value="{{ $row->id }}">
                        @csrf

                        <x-form-group class="mb-0" :properties="[
                            'input' => [
                                'name' => 'upload[]',
                                'type' => 'file',
                                'options' => [
                                    'multiple',
                                    'required',
                                    'accept' => 'image/*',
                                    'class' => 'input-upload d-none',
                                ],
                            ],
                        ]" />

                        <div class="upload-icon  text-center ">
                            <i class="fa-solid fa-arrow-up-from-bracket"></i>
                        </div>

                        <h5 class=" text-center mt-3">اختر صور للتحميل</h5>
                        <small>( {{ 'اقصى حجم : ' . $maxSize . ' ميجابيت' }} </small>
                        <small>|</small>
                        <small>{{ 'الحد الأقصي : ' . $maxFiles . ' ملف' }} )</small>
                        <br>
                        <button id="btn-browse" class="btn btn-main cursor-pointer mt-3">تصفح
                            المرفقات</button>
                        <br>
                        <a href="{{ route('properties.create') }}" class="btn btn-light border cursor-pointer mt-2">
                            <i class="fa-solid fa-sitemap"></i> اضافة نماذج للإعلان
                        </a>

                        <a href="{{ route('properties.create') }}" class="btn btn-light border cursor-pointer mt-2">
                            <i class=" fa fa-plus"></i> اضافة اعلان جديد
                        </a>

                    </div><!-- box -->

                </form><!-- form Browse File -->


            </div><!-- col -->
        </section>
    </main>


@endsection
<x-dashboard.js :links="[
    [
        'link' => 'properties/index.js',
        'type' => 'module',
    ],
]" />
