@extends('dashboard.layouts.master')
@section('title', 'رسائل الاهتمام')
@section('content')

    <x-dashboard.links-bar :links="[
        [
            'name' => 'رسائل الاهتمام',
        ],
    ]" /><!-- links bar -->

    <section id="">


        <div class="box table-responsive">
            <table class="table table-modern table-modern-sm table-inverse">
                <thead class="thead-inverse">
                    <tr>
                        @canany(['interest_read', 'interest_delete'])
                            <th>التحكم</th>
                        @endcanany
                        <th>الاسم</th>
                        <th>البريد الإلكتروني</th>
                        <th>رقم الهاتف</th>
                        <th>تاريخ الإضافة</th>
                        <th>الحالة</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($rows as $row)
                        <tr class="{{ $row->is_read ? 'table-light' : 'table-warning' }} parents">
                            @canany(['interest_read', 'interest_delete'])
                                <td>

                                    @can('interest_delete')
                                        <!-- زر الحذف -->
                                        <form class="ajax-delete d-inline-block" action="{{ route('interests.destroy') }}"
                                            method="POST">
                                            @method('DELETE')
                                            @csrf
                                            <input type="hidden" class="id" name="id" value="{{ $row->id }}">
                                            <button type="submit" class="btn-sm btn btn-soft-danger"
                                                data-delete="هل انت متأكد من حذف : {{ $row->name }}">
                                                <i class="fa fa-trash-alt"></i>
                                            </button>
                                        </form>
                                    @endcan

                                    @can('interest_read')
                                        @if (!$row->is_read)
                                            <form action="{{ route('interests.read', $row->id) }}" method="POST"
                                                class="d-inline-block">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-success">
                                                    <i class="fa fa-check"></i> تم القراءة
                                                </button>
                                            </form>
                                        @endif
                                    @endcan

                                </td>
                            @endcanany

                            <td>{{ $row->name }}</td>
                            <td>{{ $row->email ?? '-' }}</td>
                            <td>{{ $row->phone ?? '-' }}</td>
                            <td>{{ $row->created_at->format('Y-m-d H:i') }}</td>
                            <td>
                                {!! $row->is_read
                                    ? "<span class='badge badge-success'>مقروء</span>"
                                    : "<span class='badge badge-warning'>غير مقروء</span>" !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center pt-4 text-muted">لا توجد بيانات بعد</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div><!-- end box table -->


    </section><!-- section -->

@endsection
