<?php
namespace Database\Seeders;

use App\Models\Amenity;
use App\Models\City;
use App\Models\Dashboard\Admin\Admin;
use App\Models\Feature;
use App\Models\FurnishingStatus;
use App\Models\Neighborhood;
use App\Models\Property;
use App\Models\PropertyStatus;
use App\Models\PropertyType;
use Illuminate\Database\Seeder;

class PropertySeeder extends Seeder
{
    public function run()
    {
        $admin = Admin::first();

        if (! $admin) {
            $this->command->error('Please create at least one admin user before seeding properties.');
            return;
        }

        $propertyTypes      = PropertyType::all();
        $propertyStatuses   = PropertyStatus::all();
        $furnishingStatuses = FurnishingStatus::all();
        $features           = Feature::all();
        $amenities          = Amenity::all();
        $neighborhoods      = Neighborhood::all();
        $cities              = City::all();

        // عدد العقارات التجريبية المطلوب إضافتها
        $count = 0;

        $front = ['شمال', 'جنوب', 'واجهة بحري'];
        for ($i = 1; $i <= $count; $i++) {
            $neighborhood     = $neighborhoods->random();
            $city             = $cities->random();
            $propertyType     = $propertyTypes->random();
            $propertyStatus   = $propertyStatuses->random();
            $furnishingStatus = $furnishingStatuses->random();

            $title       = $propertyType->name . " رائعة في " . $neighborhood->name;
            $description = "عقار " . $propertyType->name . " بمواصفات ممتازة، يقع في منطقة " . $neighborhood->name . "، يتميز بقربه من المرافق والخدمات.";

                                               // $description = "احتاج شخص متمكن وسريع وفاهم للمشروع لدي الاكواد للموقع ذاكر لكم موقع مشابه مرتب ومنسق مع العلم انا من صممت الصفحة الاولى من موقعي لكن لم يتمكن المبرمج من التنسيق حيث تناسب شاشة التلفون";
            $price     = rand(50000, 5000000); // سعر عشوائي
            $area      = rand(50, 500);        // مساحة عشوائية
            $bedrooms  = rand(1, 7);
            $bathrooms = rand(1, 5);

            $property = Property::create([
                'admin_id'               => $admin->id,
                'neighborhood_id'        => $neighborhood->id,
                'city_id'                => $city->id,
                'property_type_id'       => $propertyType->id,
                'property_status_id'     => $propertyStatus->id,
                'furnishing_status_id'   => $furnishingStatus->id,
                'title'                  => $title,
                'description'            => $description,
                'title_normalized'       => normalizeArabic($title),
                'description_normalized' => normalizeArabic($description),
                'price'                  => $price,
                'area'                   => $area,
                'bedrooms'               => $bedrooms,
                'bathrooms'              => $bathrooms,
                'floor'                  => rand(1, 4),
                'front'                  => $front[array_rand($front)],
            ]);

            // ربط مميزات عشوائية (1 إلى 4)
            $selectedFeatures = $features->random(rand(1, min(4, $features->count())))->pluck('id')->toArray();
            $property->features()->attach($selectedFeatures);

            // ربط مرافق عشوائية (1 إلى 3)
            $selectedAmenities = $amenities->random(rand(1, min(3, $amenities->count())))->pluck('id')->toArray();
            $property->amenities()->attach($selectedAmenities);
        }
    }
}
