<?php
namespace Database\Seeders;

use App\Models\Country;
use App\Models\City;
use App\Models\Neighborhood;
use Illuminate\Database\Seeder;

class CountryRegionCitySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        // الدولة
        $saudi = Country::create([
            'name' => 'المملكة العربية السعودية',
            'code' => 'SA',
        ]);

        $City = City::count();

        if ($City == 0) {

            $list = ["الرياض", "جدة", "مكة المكرمة", "المدينة المنورة", "الدمام", "الطائف", "الأحساء", "الجبيل", "ينبع", "حائل"];
            foreach ($list as $name) {
                City::create(['name' => $name, 'country_id' => $saudi->id]);
            }

            // مصفوفة تحتوي على أسماء المدن والأحياء
            $City_neighborhoods = [
                "الرياض"          => ["الربوة", "النخيل", "العليا", "الملقا", "العزيزية"],
                "جدة"             => ["البلد", "الحمراء", "الفيصلية", "الروضة", "السلامة"],
                "مكة المكرمة"     => ["العزيزية", "الشوقية", "العوالي", "الحمراء", "الهجلة"],
                "المدينة المنورة" => ["العليا", "السلام", "النور", "العوالي", "الهجرة"],
                "الدمام"          => ["العنود", "الفيصلية", "الزهور", "الخالدية", "الشاطئ"],
            ];

            // طباعة الأحياء حسب المدينة
            foreach ($City_neighborhoods as $cityName => $neighborhoods) {

                // Get City If Exist
                $city = City::where('name', $cityName)->first(['id']);

                if ($city != null) {

                    foreach ($neighborhoods as $neighborhood) {
                        Neighborhood::create(['name' => $neighborhood, 'city_id' => $city->id]);
                    }
                }

            }
        }

    }
}
