-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Sep 29, 2025 at 02:38 AM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `internal_real_estate`
--

-- --------------------------------------------------------

--
-- Table structure for table `admins`
--

CREATE TABLE `admins` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `f_name` varchar(40) NOT NULL,
  `l_name` varchar(40) NOT NULL,
  `full_name` varchar(120) NOT NULL,
  `email` varchar(191) NOT NULL,
  `password` varchar(191) NOT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `about` text DEFAULT NULL,
  `country` varchar(75) DEFAULT NULL,
  `city` varchar(75) DEFAULT NULL,
  `zip_code` varchar(75) DEFAULT NULL,
  `skills` text DEFAULT NULL,
  `job` varchar(191) DEFAULT NULL,
  `avatar` varchar(100) DEFAULT NULL,
  `cover` varchar(100) DEFAULT NULL,
  `language` bigint(20) UNSIGNED DEFAULT NULL,
  `theme` varchar(191) NOT NULL DEFAULT 'light',
  `last_seen` timestamp NULL DEFAULT NULL,
  `status` enum('1','0') NOT NULL DEFAULT '1' COMMENT 'If the account is banned, the value will be 0',
  `joining_date` date NOT NULL DEFAULT '2025-09-29',
  `remember_token` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `admins`
--

INSERT INTO `admins` (`id`, `f_name`, `l_name`, `full_name`, `email`, `password`, `phone`, `about`, `country`, `city`, `zip_code`, `skills`, `job`, `avatar`, `cover`, `language`, `theme`, `last_seen`, `status`, `joining_date`, `remember_token`) VALUES
(1, 'System', 'Backup', 'System Backup', 'system@gmail.com', '$2y$10$KW49JWRRm2m.IwVglKJIGOobm7wb4oi5acBfO.9kI9yHNcSNUAsZu', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'light', NULL, '1', '2025-09-29', NULL),
(2, 'Admin', 'User', 'Admin User', 'admin@gmail.com', '$2y$10$enVgu93jE4i1oa/ObukH5.VSg8UQ9Oojzows1IkaYiGrmmqHhH2le', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'light', NULL, '1', '2025-09-29', 'AgxFwffpBAbJ3OdWFmuGTnnKQ6I5OtjsQE4IBVhwFI0SbUlbxpD7oa1cS3na');

-- --------------------------------------------------------

--
-- Table structure for table `admin_attributes`
--

CREATE TABLE `admin_attributes` (
  `admin_id` bigint(20) UNSIGNED NOT NULL,
  `email_verified` enum('1','0') NOT NULL DEFAULT '0' COMMENT '1: The Admin Email Is verification 0: Email Not verification',
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `forgot_password_token` text DEFAULT NULL COMMENT 'This Unique Token For Reset Password',
  `forget_password_expiry_date` varchar(60) DEFAULT NULL COMMENT 'Expiry Date For Reset Password Link By Unix timestamp'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `admin_attributes`
--

INSERT INTO `admin_attributes` (`admin_id`, `email_verified`, `email_verified_at`, `forgot_password_token`, `forget_password_expiry_date`) VALUES
(1, '0', NULL, NULL, NULL),
(2, '0', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `admin_job_experiences`
--

CREATE TABLE `admin_job_experiences` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `job_title` varchar(75) NOT NULL,
  `job_desc` text NOT NULL,
  `company_name` varchar(100) NOT NULL,
  `start_year` mediumint(9) NOT NULL,
  `end_year` mediumint(9) NOT NULL,
  `admin_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `admin_portfolios`
--

CREATE TABLE `admin_portfolios` (
  `admin_id` bigint(20) UNSIGNED NOT NULL,
  `facebook` varchar(191) DEFAULT NULL,
  `SnapChat` varchar(191) DEFAULT NULL,
  `twitter` varchar(191) DEFAULT NULL,
  `instagram` varchar(191) DEFAULT NULL,
  `youtube` varchar(191) DEFAULT NULL,
  `telegram` varchar(191) DEFAULT NULL,
  `whatsapp` varchar(191) DEFAULT NULL,
  `tiktok` varchar(191) DEFAULT NULL,
  `upwork` varchar(191) DEFAULT NULL,
  `linkedin` varchar(191) DEFAULT NULL,
  `github` varchar(191) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `admin_portfolios`
--

INSERT INTO `admin_portfolios` (`admin_id`, `facebook`, `SnapChat`, `twitter`, `instagram`, `youtube`, `telegram`, `whatsapp`, `tiktok`, `upwork`, `linkedin`, `github`) VALUES
(1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `amenities`
--

CREATE TABLE `amenities` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `amenities`
--

INSERT INTO `amenities` (`id`, `name`, `admin_id`, `created_at`, `updated_at`) VALUES
(1, 'مدرسة', NULL, NULL, NULL),
(2, 'مستشفى', NULL, NULL, NULL),
(3, 'سوبر ماركت', NULL, NULL, NULL),
(4, 'مسجد', NULL, NULL, NULL),
(5, 'مواصلات عامة', NULL, NULL, NULL),
(6, 'متنزه و حديقة عامة', NULL, NULL, NULL),
(7, 'مركز رياضي', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cities`
--

CREATE TABLE `cities` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `country_id` bigint(20) UNSIGNED NOT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cities`
--

INSERT INTO `cities` (`id`, `name`, `country_id`, `admin_id`, `created_at`, `updated_at`) VALUES
(1, 'الرياض', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(2, 'جدة', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(3, 'مكة المكرمة', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(4, 'المدينة المنورة', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(5, 'الدمام', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(6, 'الطائف', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(7, 'الأحساء', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(8, 'الجبيل', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(9, 'ينبع', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(10, 'حائل', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37');

-- --------------------------------------------------------

--
-- Table structure for table `countries`
--

CREATE TABLE `countries` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `code` varchar(5) NOT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `countries`
--

INSERT INTO `countries` (`id`, `name`, `code`, `admin_id`, `created_at`, `updated_at`) VALUES
(1, 'المملكة العربية السعودية', 'SA', NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37');

-- --------------------------------------------------------

--
-- Table structure for table `features`
--

CREATE TABLE `features` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `features`
--

INSERT INTO `features` (`id`, `name`, `admin_id`, `created_at`, `updated_at`) VALUES
(1, 'مسبح', NULL, NULL, NULL),
(2, 'موقف سيارات خاص', NULL, NULL, NULL),
(3, 'حديقة', NULL, NULL, NULL),
(4, 'مصعد', NULL, NULL, NULL),
(5, 'نظام أمني', NULL, NULL, NULL),
(6, 'غرفة خادمة', NULL, NULL, NULL),
(7, 'غرفة غسيل', NULL, NULL, NULL),
(8, 'تكييف مركزي', NULL, NULL, NULL),
(9, 'تشطيب سوبر ديلوكس', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `furnishing_statuses`
--

CREATE TABLE `furnishing_statuses` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `furnishing_statuses`
--

INSERT INTO `furnishing_statuses` (`id`, `name`, `admin_id`, `created_at`, `updated_at`) VALUES
(1, 'مفروش كامل', NULL, NULL, NULL),
(2, 'مفروش جزئي', NULL, NULL, NULL),
(3, 'غير مفروش', NULL, NULL, NULL),
(4, 'تأثيث فاخر', NULL, NULL, NULL),
(5, 'تأثيث عادي', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `interests`
--

CREATE TABLE `interests` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(150) NOT NULL,
  `email` varchar(150) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `is_read` enum('1','0') NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `languages`
--

CREATE TABLE `languages` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `language_name` varchar(100) NOT NULL,
  `language_code` varchar(50) NOT NULL COMMENT 'Type the code lowercase letters'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `languages`
--

INSERT INTO `languages` (`id`, `language_name`, `language_code`) VALUES
(1, 'English', 'en'),
(2, 'Arabic', 'ar');

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2013_04_15_211134_create_languages_table', 1),
(2, '2014_10_12_100000_create_password_resets_table', 1),
(3, '2019_12_14_000001_create_personal_access_tokens_table', 1),
(4, '2022_06_15_142950_create_admin_table', 1),
(5, '2022_06_15_224851_create_admin_job_experiences_table', 1),
(6, '2022_06_15_224852_create_admin_attributes', 1),
(7, '2022_06_15_224853_create_admin_portfolios_table', 1),
(8, '2022_09_09_161406_create_permission_tables', 1),
(9, '2022_10_26_184039_settings', 1),
(10, '2024_03_17_213737_create_countries_table', 1),
(11, '2024_04_29_161909_create_cities_table', 1),
(12, '2024_04_29_164400_create_neighborhoods_table', 1),
(13, '2025_09_17_214011_create_property_types_table', 1),
(14, '2025_09_17_214036_create_property_statuses_table', 1),
(15, '2025_09_17_214107_create_furnishing_statuses_table', 1),
(16, '2025_09_17_214123_create_features_table', 1),
(17, '2025_09_17_214141_create_amenities_table', 1),
(18, '2025_09_17_214236_create_properties_table', 1),
(19, '2025_09_17_214506_create_property_feature_table', 1),
(20, '2025_09_17_214530_create_property_amenity_table', 1),
(21, '2025_09_17_214619_create_property_attachments_table', 1),
(22, '2025_09_18_172144_create_property_units_table', 1),
(23, '2025_09_28_062928_create_interests_table', 1);

-- --------------------------------------------------------

--
-- Table structure for table `model_has_permissions`
--

CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `model_has_roles`
--

CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `model_has_roles`
--

INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
(1, 'App\\Models\\Dashboard\\Admin\\Admin', 3),
(2, 'App\\Models\\Dashboard\\Admin\\Admin', 1),
(2, 'App\\Models\\Dashboard\\Admin\\Admin', 2);

-- --------------------------------------------------------

--
-- Table structure for table `neighborhoods`
--

CREATE TABLE `neighborhoods` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `city_id` bigint(20) UNSIGNED NOT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `neighborhoods`
--

INSERT INTO `neighborhoods` (`id`, `name`, `city_id`, `admin_id`, `created_at`, `updated_at`) VALUES
(1, 'الربوة', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(2, 'النخيل', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(3, 'العليا', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(4, 'الملقا', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(5, 'العزيزية', 1, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(6, 'البلد', 2, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(7, 'الحمراء', 2, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(8, 'الفيصلية', 2, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(9, 'الروضة', 2, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(10, 'السلامة', 2, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(11, 'العزيزية', 3, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(12, 'الشوقية', 3, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(13, 'العوالي', 3, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(14, 'الحمراء', 3, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(15, 'الهجلة', 3, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(16, 'العليا', 4, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(17, 'السلام', 4, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(18, 'النور', 4, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(19, 'العوالي', 4, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(20, 'الهجرة', 4, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(21, 'العنود', 5, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(22, 'الفيصلية', 5, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(23, 'الزهور', 5, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(24, 'الخالدية', 5, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(25, 'الشاطئ', 5, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37');

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `permissions`
--

CREATE TABLE `permissions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `display_name` varchar(191) NOT NULL,
  `group_name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` (`id`, `name`, `display_name`, `group_name`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'admins', 'عرض صفحة المستخدمين', 'admin', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(2, 'show_another_admins_profile', 'السماح بمشاهدة ملف مستخدم اخر', 'admin', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(3, 'create_admin', 'إمكانية اضافة مستخدم جديد', 'admin', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(4, 'activate_deactivate_admin', 'فتح التحكم لتغير حالة حساب المستخدمين', 'admin', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(5, 'properties_allow_search', 'السماح بالبحث المتقدم', 'properties', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(6, 'properties_create', 'السماح باضافة عقار جديد', 'properties', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(7, 'properties_edit', 'السماح بالتعديل علي عقار', 'properties', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(8, 'properties_delete', 'السماح بحذف عقار', 'properties', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(9, 'properties_allow_copy_link', 'السماح بنسخ الرابط العقار', 'properties', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(10, 'properties_activate_deactivate', 'السماح بالتحكم لتغير حالة العقار تنشيط & إلغاء التنشيط', 'properties', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(11, 'city_view', 'عرض جميع المدن', 'city', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(12, 'city_create', 'السماح باضافة مدينة جديدة', 'city', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(13, 'city_edit', 'السماح بالتعديل علي المدن', 'city', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(14, 'city_delete', 'السماح بحذف مدينة', 'city', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(15, 'neighborhood_view', 'عرض جميع المناطق', 'neighborhood', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(16, 'neighborhood_create', 'السماح باضافة منطقة جديدة', 'neighborhood', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(17, 'neighborhood_edit', 'السماح بالتعديل علي المناطق', 'neighborhood', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(18, 'neighborhood_delete', 'السماح بحذف منطقة', 'neighborhood', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(19, 'property_status_view', 'عرض الحالات & الاغراض المناطق', 'property_status', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(20, 'property_status_create', 'السماح باضافة حالة & غرض جديد', 'property_status', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(21, 'property_status_edit', 'السماح بالتعديل علي الحالات & الاغراض', 'property_status', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(22, 'property_status_delete', 'السماح بحذف حالة & غرض', 'property_status', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(23, 'property_furnishing_view', 'عرض مستويات التشطيب', 'property_furnishing', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(24, 'property_furnishing_create', 'السماح باضافة مستوي تشطيب جديد', 'property_furnishing', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(25, 'property_furnishing_edit', 'السماح بالتعديل علي مستويات التشطيب', 'property_furnishing', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(26, 'property_furnishing_delete', 'السماح بحذف مستوي تشطيب', 'property_furnishing', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(27, 'property_features_view', 'عرض أنواع المميزات', 'property_features', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(28, 'property_features_create', 'السماح باضافة نوع من المميزات جديد', 'property_features', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(29, 'property_features_edit', 'السماح بالتعديل علي أنواع المميزات', 'property_features', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(30, 'property_features_delete', 'السماح بحذف نوع من المميزات', 'property_features', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(31, 'property_amenities_view', 'عرض وسائل الراحة', 'property_amenities', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(32, 'property_amenities_create', 'السماح باضافة وسيلة راحة جديدة', 'property_amenities', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(33, 'property_amenities_edit', 'السماح بالتعديل علي وسائل الراحة', 'property_amenities', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(34, 'property_amenities_delete', 'السماح بحذف من وسائل الراحة', 'property_amenities', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(35, 'website_setting_allow_edit_and_view', 'السماح بالتحكم في إعدادات الموقع', 'website_setting', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(36, 'interest_allow_view', 'السماح بمشاهدة رسائل الإهتمام', 'interests', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(37, 'interest_read', 'السماح بتغير حالة رسائل الإهتمام', 'interests', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37'),
(38, 'interest_delete', 'السماح بحذف رسائل الإهتمام', 'interests', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37');

-- --------------------------------------------------------

--
-- Table structure for table `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `tokenable_type` varchar(191) NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `properties`
--

CREATE TABLE `properties` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(191) NOT NULL,
  `uuid` char(36) NOT NULL,
  `description` text DEFAULT NULL,
  `main_image` varchar(100) DEFAULT NULL,
  `price` int(10) UNSIGNED NOT NULL,
  `area` double(8,2) DEFAULT NULL,
  `bedrooms` int(11) DEFAULT NULL,
  `bathrooms` int(11) DEFAULT NULL,
  `floor` varchar(50) DEFAULT NULL COMMENT 'الدور',
  `front` varchar(45) DEFAULT NULL COMMENT 'الواجهة',
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `google_map_iframe` text DEFAULT NULL,
  `city_id` bigint(20) UNSIGNED DEFAULT NULL,
  `neighborhood_id` bigint(20) UNSIGNED DEFAULT NULL,
  `property_type_id` bigint(20) UNSIGNED DEFAULT NULL,
  `property_status_id` bigint(20) UNSIGNED DEFAULT NULL,
  `furnishing_status_id` bigint(20) UNSIGNED DEFAULT NULL,
  `title_normalized` varchar(191) NOT NULL,
  `description_normalized` text DEFAULT NULL,
  `views_count` bigint(20) UNSIGNED NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `property_amenity`
--

CREATE TABLE `property_amenity` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `property_id` bigint(20) UNSIGNED NOT NULL,
  `amenity_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `property_attachments`
--

CREATE TABLE `property_attachments` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `property_id` bigint(20) UNSIGNED NOT NULL,
  `attachment_name` varchar(100) NOT NULL,
  `extension` varchar(30) NOT NULL,
  `type` varchar(30) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `property_feature`
--

CREATE TABLE `property_feature` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `property_id` bigint(20) UNSIGNED NOT NULL,
  `feature_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `property_statuses`
--

CREATE TABLE `property_statuses` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `property_statuses`
--

INSERT INTO `property_statuses` (`id`, `name`, `admin_id`, `created_at`, `updated_at`) VALUES
(1, 'للبيع', NULL, NULL, NULL),
(2, 'للإيجار', NULL, NULL, NULL),
(3, 'تم البيع', NULL, NULL, NULL),
(4, 'مستأجر', NULL, NULL, NULL),
(5, 'قيد الإنشاء', NULL, NULL, NULL),
(6, 'غير متاح', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `property_types`
--

CREATE TABLE `property_types` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `property_types`
--

INSERT INTO `property_types` (`id`, `name`, `admin_id`, `created_at`, `updated_at`) VALUES
(1, 'شقة', NULL, NULL, NULL),
(2, 'فيلا', NULL, NULL, NULL),
(3, 'منزل مستقل', NULL, NULL, NULL),
(4, 'محل تجاري', NULL, NULL, NULL),
(5, 'أرض', NULL, NULL, NULL),
(6, 'مكتب', NULL, NULL, NULL),
(7, 'استوديو', NULL, NULL, NULL),
(8, 'دوبلكس', NULL, NULL, NULL),
(9, 'شقة فندقية', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `property_units`
--

CREATE TABLE `property_units` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(60) NOT NULL,
  `area` varchar(191) NOT NULL,
  `bedrooms` varchar(191) NOT NULL,
  `bathrooms` varchar(191) NOT NULL,
  `price` int(10) UNSIGNED NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `property_id` bigint(20) UNSIGNED NOT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'admin', 'admin', '2025-09-29 00:23:36', '2025-09-29 00:23:36'),
(2, 'owner', 'admin', '2025-09-29 00:23:37', '2025-09-29 00:23:37');

-- --------------------------------------------------------

--
-- Table structure for table `role_has_permissions`
--

CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `role_has_permissions`
--

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1);

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `logo` varchar(100) DEFAULT NULL,
  `website_icon` varchar(100) DEFAULT NULL,
  `website_name` varchar(100) DEFAULT NULL,
  `website_desc` text DEFAULT NULL,
  `email` varchar(120) DEFAULT NULL,
  `phone` varchar(60) DEFAULT NULL,
  `facebook` varchar(191) DEFAULT NULL,
  `snapchat` varchar(191) DEFAULT NULL,
  `twitter` varchar(191) DEFAULT NULL,
  `instagram` varchar(191) DEFAULT NULL,
  `youtube` varchar(191) DEFAULT NULL,
  `telegram` varchar(191) DEFAULT NULL,
  `whatsapp` varchar(191) DEFAULT NULL,
  `tiktok` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`id`, `logo`, `website_icon`, `website_name`, `website_desc`, `email`, `phone`, `facebook`, `snapchat`, `twitter`, `instagram`, `youtube`, `telegram`, `whatsapp`, `tiktok`, `created_at`, `updated_at`) VALUES
(1, 'logo.png', 'fav.png', 'شركة رئال للتطوير العقاري', 'شركة رئال للتطوير العقاري هي شركة سعودية رائدة في مجال التطوير العقاري والتسويق، ملتزمة بتقديم حلول عقارية متكاملة تلبي احتياجات العملاء والمستثمرين على حد', 'info@salehmegawer.com', '966557712237', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-29 00:23:37', '2025-09-29 00:23:37');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `admins`
--
ALTER TABLE `admins`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `admins_email_unique` (`email`),
  ADD UNIQUE KEY `admins_phone_unique` (`phone`),
  ADD KEY `admins_language_foreign` (`language`);

--
-- Indexes for table `admin_attributes`
--
ALTER TABLE `admin_attributes`
  ADD UNIQUE KEY `admin_attributes_admin_id_unique` (`admin_id`);

--
-- Indexes for table `admin_job_experiences`
--
ALTER TABLE `admin_job_experiences`
  ADD PRIMARY KEY (`id`),
  ADD KEY `admin_job_experiences_admin_id_foreign` (`admin_id`);

--
-- Indexes for table `admin_portfolios`
--
ALTER TABLE `admin_portfolios`
  ADD UNIQUE KEY `admin_portfolios_admin_id_unique` (`admin_id`);

--
-- Indexes for table `amenities`
--
ALTER TABLE `amenities`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `amenities_name_unique` (`name`),
  ADD KEY `amenities_admin_id_foreign` (`admin_id`);

--
-- Indexes for table `cities`
--
ALTER TABLE `cities`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `cities_name_country_id_unique` (`name`,`country_id`),
  ADD KEY `cities_country_id_foreign` (`country_id`),
  ADD KEY `cities_admin_id_foreign` (`admin_id`);

--
-- Indexes for table `countries`
--
ALTER TABLE `countries`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `countries_name_unique` (`name`),
  ADD UNIQUE KEY `countries_code_unique` (`code`),
  ADD KEY `countries_admin_id_foreign` (`admin_id`);

--
-- Indexes for table `features`
--
ALTER TABLE `features`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `features_name_unique` (`name`),
  ADD KEY `features_admin_id_foreign` (`admin_id`);

--
-- Indexes for table `furnishing_statuses`
--
ALTER TABLE `furnishing_statuses`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `furnishing_statuses_name_unique` (`name`),
  ADD KEY `furnishing_statuses_admin_id_foreign` (`admin_id`);

--
-- Indexes for table `interests`
--
ALTER TABLE `interests`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `languages`
--
ALTER TABLE `languages`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  ADD KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  ADD KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `neighborhoods`
--
ALTER TABLE `neighborhoods`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `neighborhoods_name_city_id_unique` (`name`,`city_id`),
  ADD KEY `neighborhoods_city_id_foreign` (`city_id`),
  ADD KEY `neighborhoods_admin_id_foreign` (`admin_id`);

--
-- Indexes for table `password_resets`
--
ALTER TABLE `password_resets`
  ADD KEY `password_resets_email_index` (`email`);

--
-- Indexes for table `permissions`
--
ALTER TABLE `permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`);

--
-- Indexes for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`);

--
-- Indexes for table `properties`
--
ALTER TABLE `properties`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `properties_uuid_unique` (`uuid`),
  ADD KEY `properties_admin_id_foreign` (`admin_id`),
  ADD KEY `properties_city_id_foreign` (`city_id`),
  ADD KEY `properties_neighborhood_id_foreign` (`neighborhood_id`),
  ADD KEY `properties_property_type_id_foreign` (`property_type_id`),
  ADD KEY `properties_property_status_id_foreign` (`property_status_id`),
  ADD KEY `properties_furnishing_status_id_foreign` (`furnishing_status_id`),
  ADD KEY `properties_price_index` (`price`),
  ADD KEY `properties_area_index` (`area`),
  ADD KEY `properties_views_count_index` (`views_count`);
ALTER TABLE `properties` ADD FULLTEXT KEY `title_normalized` (`title_normalized`,`description_normalized`);

--
-- Indexes for table `property_amenity`
--
ALTER TABLE `property_amenity`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `property_amenity_property_id_amenity_id_unique` (`property_id`,`amenity_id`),
  ADD KEY `property_amenity_amenity_id_foreign` (`amenity_id`);

--
-- Indexes for table `property_attachments`
--
ALTER TABLE `property_attachments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `property_attachments_property_id_foreign` (`property_id`);

--
-- Indexes for table `property_feature`
--
ALTER TABLE `property_feature`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `property_feature_property_id_feature_id_unique` (`property_id`,`feature_id`),
  ADD KEY `property_feature_feature_id_foreign` (`feature_id`);

--
-- Indexes for table `property_statuses`
--
ALTER TABLE `property_statuses`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `property_statuses_name_unique` (`name`),
  ADD KEY `property_statuses_admin_id_foreign` (`admin_id`);

--
-- Indexes for table `property_types`
--
ALTER TABLE `property_types`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `property_types_name_unique` (`name`),
  ADD KEY `property_types_admin_id_foreign` (`admin_id`);

--
-- Indexes for table `property_units`
--
ALTER TABLE `property_units`
  ADD PRIMARY KEY (`id`),
  ADD KEY `property_units_property_id_foreign` (`property_id`),
  ADD KEY `property_units_admin_id_foreign` (`admin_id`),
  ADD KEY `property_units_price_index` (`price`);

--
-- Indexes for table `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`);

--
-- Indexes for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`role_id`),
  ADD KEY `role_has_permissions_role_id_foreign` (`role_id`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `admins`
--
ALTER TABLE `admins`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `admin_job_experiences`
--
ALTER TABLE `admin_job_experiences`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `amenities`
--
ALTER TABLE `amenities`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `cities`
--
ALTER TABLE `cities`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `countries`
--
ALTER TABLE `countries`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `features`
--
ALTER TABLE `features`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `furnishing_statuses`
--
ALTER TABLE `furnishing_statuses`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `interests`
--
ALTER TABLE `interests`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `languages`
--
ALTER TABLE `languages`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `neighborhoods`
--
ALTER TABLE `neighborhoods`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=26;

--
-- AUTO_INCREMENT for table `permissions`
--
ALTER TABLE `permissions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=39;

--
-- AUTO_INCREMENT for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `properties`
--
ALTER TABLE `properties`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `property_amenity`
--
ALTER TABLE `property_amenity`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `property_attachments`
--
ALTER TABLE `property_attachments`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `property_feature`
--
ALTER TABLE `property_feature`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `property_statuses`
--
ALTER TABLE `property_statuses`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `property_types`
--
ALTER TABLE `property_types`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `property_units`
--
ALTER TABLE `property_units`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `roles`
--
ALTER TABLE `roles`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `admins`
--
ALTER TABLE `admins`
  ADD CONSTRAINT `admins_language_foreign` FOREIGN KEY (`language`) REFERENCES `languages` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `admin_attributes`
--
ALTER TABLE `admin_attributes`
  ADD CONSTRAINT `admin_attributes_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `admin_job_experiences`
--
ALTER TABLE `admin_job_experiences`
  ADD CONSTRAINT `admin_job_experiences_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `admin_portfolios`
--
ALTER TABLE `admin_portfolios`
  ADD CONSTRAINT `admin_portfolios_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `amenities`
--
ALTER TABLE `amenities`
  ADD CONSTRAINT `amenities_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `cities`
--
ALTER TABLE `cities`
  ADD CONSTRAINT `cities_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `cities_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `countries`
--
ALTER TABLE `countries`
  ADD CONSTRAINT `countries_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `features`
--
ALTER TABLE `features`
  ADD CONSTRAINT `features_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `furnishing_statuses`
--
ALTER TABLE `furnishing_statuses`
  ADD CONSTRAINT `furnishing_statuses_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD CONSTRAINT `model_has_permissions_model_id_foreign` FOREIGN KEY (`model_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `neighborhoods`
--
ALTER TABLE `neighborhoods`
  ADD CONSTRAINT `neighborhoods_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `neighborhoods_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `properties`
--
ALTER TABLE `properties`
  ADD CONSTRAINT `properties_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `properties_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `properties_furnishing_status_id_foreign` FOREIGN KEY (`furnishing_status_id`) REFERENCES `furnishing_statuses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `properties_neighborhood_id_foreign` FOREIGN KEY (`neighborhood_id`) REFERENCES `neighborhoods` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `properties_property_status_id_foreign` FOREIGN KEY (`property_status_id`) REFERENCES `property_statuses` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `properties_property_type_id_foreign` FOREIGN KEY (`property_type_id`) REFERENCES `property_types` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `property_amenity`
--
ALTER TABLE `property_amenity`
  ADD CONSTRAINT `property_amenity_amenity_id_foreign` FOREIGN KEY (`amenity_id`) REFERENCES `amenities` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `property_amenity_property_id_foreign` FOREIGN KEY (`property_id`) REFERENCES `properties` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `property_attachments`
--
ALTER TABLE `property_attachments`
  ADD CONSTRAINT `property_attachments_property_id_foreign` FOREIGN KEY (`property_id`) REFERENCES `properties` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `property_feature`
--
ALTER TABLE `property_feature`
  ADD CONSTRAINT `property_feature_feature_id_foreign` FOREIGN KEY (`feature_id`) REFERENCES `features` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `property_feature_property_id_foreign` FOREIGN KEY (`property_id`) REFERENCES `properties` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `property_statuses`
--
ALTER TABLE `property_statuses`
  ADD CONSTRAINT `property_statuses_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `property_types`
--
ALTER TABLE `property_types`
  ADD CONSTRAINT `property_types_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `property_units`
--
ALTER TABLE `property_units`
  ADD CONSTRAINT `property_units_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `property_units_property_id_foreign` FOREIGN KEY (`property_id`) REFERENCES `properties` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
