<?php
namespace App\Http\Controllers\Property;

use App\Helpers\Response;
use App\Http\Controllers\Controller;
use App\Models\Feature;
use Illuminate\Http\Request;

class FeaturesController extends Controller
{

    public function __construct()
    {
        $this->middleware(['permission:property_features_view'], ['only' => ['index']]);
        $this->middleware(['permission:property_features_create'], ['only' => ['store']]);
        $this->middleware(['permission:property_features_edit'], ['only' => ['update']]);
        $this->middleware(['permission:property_features_delete'], ['only' => ['destroy']]);
    }

    public function routes($route)
    {
        $routes = [
            'index'   => route('property.features.index'),
            'update'  => route('property.features.update'),
            'store'   => route('property.features.store'),
            'destroy' => route('property.features.destroy'),
        ];

        return $routes[$route];
    }

    public function model()
    {
        return (new Feature);
    }

    // Show All Rows
    public function index()
    {

        $rows = $this->model()::with('admin')->orderByDesc('id')->get();

        $destroyRoute = $this->routes('destroy');

        // Check IF Have Edit
        $id = intval(request('edit'));

        if ($id != 0) {
            $editRow = $this->model()::where('id', $id)->first()->toArray();
            // Form Update Options
            $formOption = [
                'panelTitle'   => 'تحديث الميزة ',
                'submitButton' => 'تحديث',
                'formAction'   => $this->routes('update'),
            ];

            if ($editRow == null) {
                return redirect($this->routes('index'))->with('warning', 'البيانات المطلوبة غير متاحة في النظام');
            }
        } else {

            // Form Create Options
            $editRow    = [];
            $formOption = [
                'panelTitle'   => 'اضافة ميزة جديدة',
                'submitButton' => 'اضافة',
                'formAction'   => $this->routes('store'),
            ];
        }

        return view('dashboard.system-data.features', compact('rows', 'editRow', 'formOption', 'destroyRoute'));
    }

    // Insert New Row
    public function store(Request $request)
    {

        //
        $data = $request->validate([
            'name' => 'required|max:60|min:2|unique:' . $this->model()->table . ',name',
        ]);

        //
        $data['admin_id'] = adminId();

        // Insert
        $this->model()->create($data);

        return Response::success('تم اضافة البيانات بنجاح...', ['style' => 'toastr', 'reset' => true, 'reload' => true, 'time_out' => 1]);
    }

    // Update Row
    public function update(Request $request)
    {

        $row = $this->model()::where('id', $request->id)->first();

        // Check If Not Exists in db
        if ($row == null) {
            return Response::error('البيانات المطلوبة غير متوفرة في النظام', ['style' => 'toastr']);
        }

        // Validate Data
        $data = $request->validate([
            'name' => 'required|max:150|min:2|unique:' . $this->model()->table . ',name,' . $row->id,
        ]);

        // Insert
        $row->update($data);

        // Return Message
        return Response::success('تم تحديث البيانات بنجاح...', ['style' => 'toastr', 'redirect' => $this->routes('index'), 'reload' => true, 'time_out' => 1]);
    }

    // Delete Row
    public function destroy()
    {
        // Get Row And Check IF IN Database
        $row = $this->model()::find(request('id'));

        // Check If Not Exist The Row IN Database
        if (empty($row)) {
            // Message
            return Response::error('هذه العملية غير مصرح بها، وقد لا تكون البيانات المطلوبة متاحة في النظام', ['style' => 'toastr']);
        } else {
            // Delete From DB
            $row->delete();
            //Message
            return Response::success('تم حذف البيانات بنجاح', ['style' => 'toastr']);
        }
    }

} // End Class
