<?php
namespace App\Http\Controllers;

use App\Helpers\Response;
use App\Models\Interest;
use Illuminate\Http\Request;

class InterestController extends Controller
{

    public function __construct()
    {
        $this->middleware(['permission:interest_allow_view'], ['only' => 'index']);
        $this->middleware(['permission:interests_read'], ['only' => 'markAsRead']);
        $this->middleware(['permission:interest_delete'], ['only' => 'destroy']);
    }

    public function index(Request $request)
    {
        $rows = Interest::orderByDesc('id')->get();

        return view('dashboard.interest.index', compact('rows'));
    }

    public function markAsRead($id)
    {
        $interest          = Interest::findOrFail($id);
        $interest->is_read = '1';
        $interest->save();

        return back()->with('success', 'تم وضع الرسالة كمقروءة.');
    }

    public function destroy()
    {
        // Get Row And Check IF IN Database
        $row = Interest::find(request('id'));

        // Check If Not Exist The Row IN Database
        if (empty($row)) {
            // Message
            return Response::error('هذه العملية غير مصرح بها، وقد لا تكون البيانات المطلوبة متاحة في النظام', ['style' => 'toastr']);
        } else {

            // Delete From DB
            $row->delete();
            //Message
            return Response::success('تم حذف الرسالة بنجاح', ['style' => 'toastr']);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name'  => 'required|string|max:150',
            'email' => 'nullable|email|max:150',
            'phone' => 'required|string|max:50',
        ], [
            'name.required'  => 'من فضلك أدخل الاسم الكامل.',
            'email.required' => 'البريد الإلكتروني مطلوب.',
            'phone.required' => 'رقم الهاتف مطلوب.',
            'email.email'    => 'من فضلك أدخل بريد إلكتروني صحيح.',
            'phone.max'      => 'رقم الهاتف طويل جدًا.',
        ]);

        Interest::create($validated);

        return back()->with('success', 'تم تسجيل اهتمامك بنجاح ، سنتواصل معك قريبًا.');
    }
}
